/*
 * Decompiled with CFR 0.152.
 */
package fpp.compiler.codegen;

import fpp.compiler.analysis.Format;
import fpp.compiler.analysis.Format$Field$Default$;
import fpp.compiler.analysis.Format$Field$Integer$;
import fpp.compiler.analysis.Format$Field$Integer$Character$;
import fpp.compiler.analysis.Format$Field$Integer$Decimal$;
import fpp.compiler.analysis.Format$Field$Integer$Hexadecimal$;
import fpp.compiler.analysis.Format$Field$Integer$Octal$;
import fpp.compiler.analysis.Format$Field$Rational$;
import fpp.compiler.analysis.Format$Field$Rational$Exponent$;
import fpp.compiler.analysis.Format$Field$Rational$Fixed$;
import fpp.compiler.analysis.Format$Field$Rational$General$;
import fpp.compiler.ast.Ast;
import fpp.compiler.ast.Ast$TypeNameBool$;
import fpp.compiler.ast.Ast$TypeNameFloat$;
import fpp.compiler.ast.Ast$TypeNameInt$;
import fpp.compiler.ast.Ast$TypeNameQualIdent$;
import fpp.compiler.ast.Ast$TypeNameString$;
import fpp.compiler.ast.AstNode;
import fpp.compiler.codegen.TypeUtils;
import fpp.compiler.codegen.TypeUtils$;
import fpp.compiler.codegen.TypeUtils$Signed$;
import fpp.compiler.codegen.TypeUtils$Unsigned$;
import fpp.compiler.util.InternalError;
import java.io.Serializable;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.math.BigInt;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class FormatXmlWriter$
implements Serializable {
    public static final FormatXmlWriter$ MODULE$ = new FormatXmlWriter$();

    private FormatXmlWriter$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(FormatXmlWriter$.class);
    }

    public String fieldToString(Format.Field f, AstNode<Ast.TypeName> tn) {
        String string2;
        Format.Field field2 = f;
        if (Format$Field$Default$.MODULE$.equals(field2)) {
            string2 = this.default$1(tn);
        } else if (field2 instanceof Format.Field.Integer) {
            Format.Field.Integer.Type type;
            Format.Field.Integer integer = Format$Field$Integer$.MODULE$.unapply((Format.Field.Integer)field2);
            Format.Field.Integer.Type t = type = integer._1();
            string2 = this.integer$1(tn, t);
        } else if (field2 instanceof Format.Field.Rational) {
            Format.Field.Rational rational = Format$Field$Rational$.MODULE$.unapply((Format.Field.Rational)field2);
            Option<BigInt> option = rational._1();
            Format.Field.Rational.Type type = rational._2();
            Option<BigInt> precision = option;
            Format.Field.Rational.Type t = type;
            string2 = this.rational$1(tn, precision, t);
        } else {
            throw new MatchError(field2);
        }
        return string2;
    }

    public String formatToString(Format f, List<AstNode<Ast.TypeName>> nodes) {
        List<Tuple2<Format.Field, String>> fields = f.fields();
        if (fields.length() != nodes.length()) {
            throw new InternalError("number of nodes should match number of fields");
        }
        List pairs = (List)fields.zip(nodes);
        String s0 = this.escapePercent$1(f.prefix());
        return pairs.foldLeft(s0, (Function2<String, Tuple2, String> & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2;
            String s1;
            Tuple2 tuple22;
            block3: {
                Tuple2<String, Tuple2> tuple23;
                block2: {
                    tuple23 = Tuple2$.MODULE$.apply(x$1, x$2);
                    if (tuple23 == null) break block2;
                    tuple22 = tuple23._2();
                    s1 = tuple23._1();
                    if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) break block3;
                }
                throw new MatchError(tuple23);
            }
            Format.Field field2 = (Format.Field)tuple2._1();
            String s2 = (String)tuple2._2();
            AstNode tn = (AstNode)tuple22._2();
            return StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(s1), this.fieldToString(field2, tn))), this.escapePercent$1(s2));
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String default$1(AstNode tn$1) {
        Option<AstNode<Ast.Expr>> option;
        Ast.TypeName typeName = (Ast.TypeName)tn$1.data();
        if (typeName instanceof Ast.TypeNameFloat) {
            Ast.TypeFloat typeFloat;
            Ast.TypeNameFloat typeNameFloat = Ast$TypeNameFloat$.MODULE$.unapply((Ast.TypeNameFloat)typeName);
            Ast.TypeFloat name = typeFloat = typeNameFloat._1();
            return "%g";
        }
        if (typeName instanceof Ast.TypeNameInt) {
            Ast.TypeNameInt typeNameInt = Ast$TypeNameInt$.MODULE$.unapply((Ast.TypeNameInt)typeName);
            Ast.TypeInt typeInt = typeNameInt._1();
            Ast.TypeInt typeInt2 = typeInt;
            Tuple2<Integer, TypeUtils.Signedness> tuple2 = Tuple2$.MODULE$.apply(BoxesRunTime.boxToInteger(TypeUtils$.MODULE$.width(typeInt2)), TypeUtils$.MODULE$.signedness(typeInt2));
            if (tuple2 == null) throw new MatchError(tuple2);
            int n = BoxesRunTime.unboxToInt(tuple2._1());
            TypeUtils.Signedness signedness = tuple2._2();
            if (64 == n && TypeUtils$Signed$.MODULE$.equals(signedness)) {
                return "%ld";
            }
            if (TypeUtils$Signed$.MODULE$.equals(signedness)) {
                return "%d";
            }
            if (64 == n && TypeUtils$Unsigned$.MODULE$.equals(signedness)) {
                return "%lu";
            }
            if (!TypeUtils$Unsigned$.MODULE$.equals(signedness)) throw new MatchError(tuple2);
            return "%u";
        }
        if (typeName instanceof Ast.TypeNameQualIdent) {
            AstNode<Ast.QualIdent> astNode;
            Ast.TypeNameQualIdent typeNameQualIdent = Ast$TypeNameQualIdent$.MODULE$.unapply((Ast.TypeNameQualIdent)typeName);
            AstNode<Ast.QualIdent> name = astNode = typeNameQualIdent._1();
            return "%s";
        }
        if (Ast$TypeNameBool$.MODULE$.equals(typeName)) {
            return "%d";
        }
        if (!(typeName instanceof Ast.TypeNameString)) throw new MatchError(typeName);
        Ast.TypeNameString typeNameString = Ast$TypeNameString$.MODULE$.unapply((Ast.TypeNameString)typeName);
        Option<AstNode<Ast.Expr>> size = option = typeNameString._1();
        return "%s";
    }

    /*
     * Enabled aggressive block sorting
     */
    private final String integer$1(AstNode tn$2, Format.Field.Integer.Type t) {
        String string2;
        Ast.TypeName typeName = (Ast.TypeName)tn$2.data();
        if (!(typeName instanceof Ast.TypeNameInt)) {
            string2 = this.default$1(tn$2);
            return string2;
        }
        Ast.TypeNameInt typeNameInt = Ast$TypeNameInt$.MODULE$.unapply((Ast.TypeNameInt)typeName);
        Ast.TypeInt typeInt = typeNameInt._1();
        Ast.TypeInt typeInt2 = typeInt;
        Tuple3<Format.Field.Integer.Type, Integer, TypeUtils.Signedness> tuple3 = Tuple3$.MODULE$.apply(t, BoxesRunTime.boxToInteger(TypeUtils$.MODULE$.width(typeInt2)), TypeUtils$.MODULE$.signedness(typeInt2));
        if (tuple3 == null) throw new MatchError(tuple3);
        Format.Field.Integer.Type type = tuple3._1();
        int n = BoxesRunTime.unboxToInt(tuple3._2());
        TypeUtils.Signedness signedness = tuple3._3();
        if (Format$Field$Integer$Decimal$.MODULE$.equals(type) && 64 == n) {
            if (TypeUtils$Signed$.MODULE$.equals(signedness)) {
                return "%ld";
            }
            if (TypeUtils$Unsigned$.MODULE$.equals(signedness)) {
                return "%lu";
            }
        }
        if (Format$Field$Integer$Hexadecimal$.MODULE$.equals(type) && 64 == n) {
            return "%lx";
        }
        if (Format$Field$Integer$Octal$.MODULE$.equals(type) && 64 == n) {
            return "%lo";
        }
        if (Format$Field$Integer$Character$.MODULE$.equals(type)) {
            if (64 != n) return "%c";
            string2 = this.default$1(tn$2);
            return string2;
        }
        if (Format$Field$Integer$Decimal$.MODULE$.equals(type)) {
            if (TypeUtils$Signed$.MODULE$.equals(signedness)) {
                return "%d";
            }
            if (TypeUtils$Unsigned$.MODULE$.equals(signedness)) {
                return "%u";
            }
        }
        if (Format$Field$Integer$Hexadecimal$.MODULE$.equals(type)) {
            return "%x";
        }
        if (!Format$Field$Integer$Octal$.MODULE$.equals(type)) throw new MatchError(tuple3);
        return "%o";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final String rational$1(AstNode tn$3, Option precision, Format.Field.Rational.Type t) {
        String string2;
        Ast.TypeName typeName = (Ast.TypeName)tn$3.data();
        if (typeName instanceof Ast.TypeNameFloat) {
            String string3;
            Ast.TypeNameFloat typeNameFloat = Ast$TypeNameFloat$.MODULE$.unapply((Ast.TypeNameFloat)typeName);
            Ast.TypeFloat typeFloat = typeNameFloat._1();
            Option option = precision;
            if (option instanceof Some) {
                BigInt p = (BigInt)((Some)option).value();
                string3 = new StringBuilder(1).append(".").append(p.toString()).toString();
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError(option);
                string3 = "";
            }
            String precisionStr = string3;
            Format.Field.Rational.Type type = t;
            if (Format$Field$Rational$Exponent$.MODULE$.equals(type)) {
                string2 = new StringBuilder(2).append("%").append(precisionStr).append("e").toString();
                return string2;
            } else if (Format$Field$Rational$Fixed$.MODULE$.equals(type)) {
                string2 = new StringBuilder(2).append("%").append(precisionStr).append("f").toString();
                return string2;
            } else {
                if (!Format$Field$Rational$General$.MODULE$.equals(type)) throw new MatchError(type);
                string2 = new StringBuilder(2).append("%").append(precisionStr).append("g").toString();
            }
            return string2;
        } else {
            string2 = this.default$1(tn$3);
        }
        return string2;
    }

    private final String escapePercent$1(String s) {
        return s.replaceAll("%", "%%");
    }
}

