/*
 * Decompiled with CFR 0.152.
 */
package fpp.compiler.util;

import fpp.compiler.util.Error;
import fpp.compiler.util.File$;
import fpp.compiler.util.File$Path$;
import fpp.compiler.util.File$StdIn$;
import fpp.compiler.util.FileError$CannotOpen$;
import fpp.compiler.util.Location;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Product;
import scala.collection.immutable.List;
import scala.io.BufferedSource;
import scala.io.Codec$;
import scala.io.Source$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public interface File {
    public static File fromString(String string2) {
        return File$.MODULE$.fromString(string2);
    }

    public static java.nio.file.Path getJavaPath(String string2) {
        return File$.MODULE$.getJavaPath(string2);
    }

    public static int ordinal(File file) {
        return File$.MODULE$.ordinal(file);
    }

    public static java.nio.file.Path removeLongestPrefix(List<String> list, java.nio.file.Path path) {
        return File$.MODULE$.removeLongestPrefix(list, path);
    }

    public static String toString$(File $this) {
        return $this.toString();
    }

    default public String toString() {
        String string2;
        File file = this;
        if (file instanceof Path) {
            java.nio.file.Path path;
            Path path2 = File$Path$.MODULE$.unapply((Path)file);
            java.nio.file.Path p = path = path2._1();
            string2 = p.normalize().toString();
        } else if (File$StdIn$.MODULE$.equals(file)) {
            string2 = "stdin";
        } else {
            throw new MatchError(file);
        }
        return string2;
    }

    public static Either openRead$(File $this, Option locOpt) {
        return $this.openRead(locOpt);
    }

    default public Either<Error, char[]> openRead(Option<Location> locOpt) {
        Either either;
        try {
            BufferedSource bufferedSource;
            File file = this;
            if (file instanceof Path) {
                java.nio.file.Path path;
                Path path2 = File$Path$.MODULE$.unapply((Path)file);
                java.nio.file.Path p = path = path2._1();
                bufferedSource = Source$.MODULE$.fromFile(p.toFile(), Codec$.MODULE$.fallbackSystemCodec());
            } else if (File$StdIn$.MODULE$.equals(file)) {
                bufferedSource = Source$.MODULE$.fromInputStream(System.in, Codec$.MODULE$.fallbackSystemCodec());
            } else {
                throw new MatchError(file);
            }
            BufferedSource r = bufferedSource;
            either = package$.MODULE$.Right().apply(r.toArray(ClassTag$.MODULE$.apply(Character.TYPE)));
        }
        catch (Exception e) {
            either = package$.MODULE$.Left().apply(FileError$CannotOpen$.MODULE$.apply(locOpt, this.toString()));
        }
        return either;
    }

    public static Option openRead$default$1$(File $this) {
        return $this.openRead$default$1();
    }

    default public Option<Location> openRead$default$1() {
        return None$.MODULE$;
    }

    public static Either openWrite$(File $this, Option locOpt) {
        return $this.openWrite(locOpt);
    }

    default public Either<Error, PrintWriter> openWrite(Option<Location> locOpt) {
        Either either;
        block3: {
            try {
                File file = this;
                if (file instanceof Path) {
                    java.nio.file.Path path;
                    Path path2 = File$Path$.MODULE$.unapply((Path)file);
                    java.nio.file.Path p = path = path2._1();
                    boolean overwrite = false;
                    FileWriter fileWriter = new FileWriter(p.toFile(), overwrite);
                    PrintWriter printWriter = new PrintWriter(fileWriter);
                    either = package$.MODULE$.Right().apply(printWriter);
                    break block3;
                }
                either = package$.MODULE$.Left().apply(FileError$CannotOpen$.MODULE$.apply(locOpt, this.toString()));
            }
            catch (Exception e) {
                either = package$.MODULE$.Left().apply(FileError$CannotOpen$.MODULE$.apply(locOpt, this.toString()));
            }
        }
        return either;
    }

    public static Option openWrite$default$1$(File $this) {
        return $this.openWrite$default$1();
    }

    default public Option<Location> openWrite$default$1() {
        return None$.MODULE$;
    }

    public static final class Path
    implements File,
    Product,
    Serializable {
        private final java.nio.file.Path path;

        public static Path apply(java.nio.file.Path path) {
            return File$Path$.MODULE$.apply(path);
        }

        public static Path fromProduct(Product product) {
            return File$Path$.MODULE$.fromProduct(product);
        }

        public static Path unapply(Path path) {
            return File$Path$.MODULE$.unapply(path);
        }

        public Path(java.nio.file.Path path) {
            this.path = path;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Path)) return false;
            Path path = (Path)object;
            java.nio.file.Path path2 = this.path();
            java.nio.file.Path path3 = path.path();
            if (path2 != null) {
                if (!((Object)path2).equals(path3)) return false;
                return true;
            }
            if (path3 == null) return true;
            return false;
        }

        @Override
        public boolean canEqual(Object that) {
            return that instanceof Path;
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public String productPrefix() {
            return "Path";
        }

        @Override
        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return this._1();
        }

        @Override
        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger(n).toString());
            }
            return "path";
        }

        public java.nio.file.Path path() {
            return this.path;
        }

        public Path copy(java.nio.file.Path path) {
            return new Path(path);
        }

        public java.nio.file.Path copy$default$1() {
            return this.path();
        }

        public java.nio.file.Path _1() {
            return this.path();
        }
    }
}

