/*
 * Decompiled with CFR 0.152.
 */
package io.circe;

import cats.Contravariant;
import io.circe.KeyEncoder;
import java.io.Serializable;
import java.net.URI;
import java.util.UUID;
import scala.Function1;
import scala.Symbol;
import scala.runtime.ModuleSerializationProxy;

public final class KeyEncoder$
implements Serializable {
    private static final KeyEncoder encodeKeyString;
    private static final KeyEncoder encodeKeySymbol;
    private static final KeyEncoder encodeKeyUUID;
    private static final KeyEncoder encodeKeyURI;
    private static final KeyEncoder encodeKeyByte;
    private static final KeyEncoder encodeKeyShort;
    private static final KeyEncoder encodeKeyInt;
    private static final KeyEncoder encodeKeyLong;
    private static final Contravariant keyEncoderContravariant;
    public static final KeyEncoder$ MODULE$;

    private KeyEncoder$() {
    }

    static {
        MODULE$ = new KeyEncoder$();
        encodeKeyString = new KeyEncoder<String>(){

            public final String apply(String key) {
                return key;
            }
        };
        encodeKeySymbol = new KeyEncoder<Symbol>(){

            public final String apply(Symbol key) {
                return key.name();
            }
        };
        encodeKeyUUID = new KeyEncoder<UUID>(){

            public final String apply(UUID key) {
                return key.toString();
            }
        };
        encodeKeyURI = new KeyEncoder<URI>(){

            public final String apply(URI key) {
                return key.toString();
            }
        };
        encodeKeyByte = new KeyEncoder<Object>(){

            public final String apply(byte key) {
                return Byte.toString(key);
            }
        };
        encodeKeyShort = new KeyEncoder<Object>(){

            public final String apply(short key) {
                return Short.toString(key);
            }
        };
        encodeKeyInt = new KeyEncoder<Object>(){

            public final String apply(int key) {
                return Integer.toString(key);
            }
        };
        encodeKeyLong = new KeyEncoder<Object>(){

            public final String apply(long key) {
                return Long.toString(key);
            }
        };
        keyEncoderContravariant = new Contravariant<KeyEncoder>(){

            public final KeyEncoder contramap(KeyEncoder e, Function1 f) {
                return e.contramap(f);
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(KeyEncoder$.class);
    }

    public <A> KeyEncoder<A> apply(KeyEncoder<A> A) {
        return A;
    }

    public <A> KeyEncoder<A> instance(Function1<A, String> f) {
        return new KeyEncoder<A>(f){
            private final Function1 f$2;
            {
                this.f$2 = f$4;
            }

            public String apply(Object key) {
                return (String)this.f$2.apply(key);
            }
        };
    }

    public KeyEncoder<String> encodeKeyString() {
        return encodeKeyString;
    }

    public KeyEncoder<Symbol> encodeKeySymbol() {
        return encodeKeySymbol;
    }

    public KeyEncoder<UUID> encodeKeyUUID() {
        return encodeKeyUUID;
    }

    public KeyEncoder<URI> encodeKeyURI() {
        return encodeKeyURI;
    }

    public KeyEncoder<Object> encodeKeyByte() {
        return encodeKeyByte;
    }

    public KeyEncoder<Object> encodeKeyShort() {
        return encodeKeyShort;
    }

    public KeyEncoder<Object> encodeKeyInt() {
        return encodeKeyInt;
    }

    public KeyEncoder<Object> encodeKeyLong() {
        return encodeKeyLong;
    }

    public Contravariant<KeyEncoder> keyEncoderContravariant() {
        return keyEncoderContravariant;
    }
}

