/*
 * Decompiled with CFR 0.152.
 */
package io.circe.numbers;

import io.circe.numbers.BiggerDecimal;
import io.circe.numbers.BiggerDecimal$;
import java.math.BigDecimal;
import java.math.BigInteger;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Some$;
import scala.runtime.BoxesRunTime;

public final class SigAndExp
extends BiggerDecimal {
    private final BigInteger unscaled;
    private final BigInteger scale;

    public SigAndExp(BigInteger unscaled, BigInteger scale) {
        this.unscaled = unscaled;
        this.scale = scale;
    }

    public BigInteger unscaled() {
        return this.unscaled;
    }

    public BigInteger scale() {
        return this.scale;
    }

    @Override
    public boolean isWhole() {
        return this.scale().signum() < 1;
    }

    @Override
    public boolean isNegativeZero() {
        return false;
    }

    @Override
    public int signum() {
        return this.unscaled().signum();
    }

    @Override
    public Option<BigDecimal> toBigDecimal() {
        return this.scale().compareTo(BiggerDecimal$.MODULE$.MaxInt()) <= 0 && this.scale().compareTo(BiggerDecimal$.MODULE$.MinInt()) >= 0 ? Some$.MODULE$.apply(new BigDecimal(this.unscaled(), this.scale().intValue())) : None$.MODULE$;
    }

    @Override
    public Option<BigInteger> toBigIntegerWithMaxDigits(BigInteger maxDigits) {
        BigInteger digits;
        return !this.isWhole() ? None$.MODULE$ : ((digits = BigInteger.valueOf(this.unscaled().abs().toString().length()).subtract(this.scale())).compareTo(maxDigits) > 0 ? None$.MODULE$ : Some$.MODULE$.apply(new BigDecimal(this.unscaled(), this.scale().intValue()).toBigInteger()));
    }

    @Override
    public double toDouble() {
        return this.scale().compareTo(BiggerDecimal$.MODULE$.MaxInt()) <= 0 && this.scale().compareTo(BiggerDecimal$.MODULE$.MinInt()) >= 0 ? new BigDecimal(this.unscaled(), this.scale().intValue()).doubleValue() : (this.scale().signum() == 1 ? 0.0 : Double.POSITIVE_INFINITY) * (double)this.unscaled().signum();
    }

    @Override
    public float toFloat() {
        return this.scale().compareTo(BiggerDecimal$.MODULE$.MaxInt()) <= 0 && this.scale().compareTo(BiggerDecimal$.MODULE$.MinInt()) >= 0 ? new BigDecimal(this.unscaled(), this.scale().intValue()).floatValue() : (this.scale().signum() == 1 ? 0.0f : Float.POSITIVE_INFINITY) * (float)this.unscaled().signum();
    }

    @Override
    public Option<Object> toLong() {
        Option option;
        if (!this.isWhole()) {
            option = None$.MODULE$;
        } else {
            Option<BigInteger> option2 = this.toBigInteger();
            if (option2 instanceof Some) {
                BigInteger i = (BigInteger)((Some)option2).value();
                long asLong = i.longValue();
                option = BoxesRunTime.equals(BigInteger.valueOf(asLong), i) ? Some$.MODULE$.apply(BoxesRunTime.boxToLong(asLong)) : None$.MODULE$;
            } else if (None$.MODULE$.equals(option2)) {
                option = None$.MODULE$;
            } else {
                throw new MatchError(option2);
            }
        }
        return option;
    }

    public boolean equals(Object that) {
        boolean bl;
        Object object = that;
        if (object instanceof SigAndExp) {
            SigAndExp other = (SigAndExp)object;
            bl = BoxesRunTime.equals(this.unscaled(), other.unscaled()) && BoxesRunTime.equals(this.scale(), other.scale());
        } else {
            bl = false;
        }
        return bl;
    }

    public int hashCode() {
        return this.scale().hashCode() + this.unscaled().hashCode();
    }

    public String toString() {
        return BoxesRunTime.equals(this.scale(), BigInteger.ZERO) ? this.unscaled().toString() : new StringBuilder(1).append(this.unscaled()).append("e").append(this.scale().negate()).toString();
    }

    @Override
    public void appendToStringBuilder(StringBuilder builder) {
        builder.append(this.unscaled());
        if (!BoxesRunTime.equals(this.scale(), BigInteger.ZERO)) {
            builder.append('e');
            builder.append(this.scale().negate());
        }
    }
}

