import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementApiOperationTagConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_tag#api_operation_id ApiManagementApiOperationTag#api_operation_id}
    */
    readonly apiOperationId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_tag#display_name ApiManagementApiOperationTag#display_name}
    */
    readonly displayName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_tag#name ApiManagementApiOperationTag#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_tag#timeouts ApiManagementApiOperationTag#timeouts}
    */
    readonly timeouts?: ApiManagementApiOperationTagTimeouts;
}
export interface ApiManagementApiOperationTagTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_tag#create ApiManagementApiOperationTag#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_tag#delete ApiManagementApiOperationTag#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_tag#read ApiManagementApiOperationTag#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_tag#update ApiManagementApiOperationTag#update}
    */
    readonly update?: string;
}
export declare function apiManagementApiOperationTagTimeoutsToTerraform(struct?: ApiManagementApiOperationTagTimeoutsOutputReference | ApiManagementApiOperationTagTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementApiOperationTagTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ApiManagementApiOperationTagTimeouts | undefined;
    set internalValue(value: ApiManagementApiOperationTagTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_tag azurerm_api_management_api_operation_tag}
*/
export declare class ApiManagementApiOperationTag extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_operation_tag azurerm_api_management_api_operation_tag} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementApiOperationTagConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementApiOperationTagConfig);
    private _apiOperationId?;
    get apiOperationId(): string;
    set apiOperationId(value: string);
    get apiOperationIdInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    get displayNameInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApiManagementApiOperationTagTimeoutsOutputReference;
    putTimeouts(value: ApiManagementApiOperationTagTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApiManagementApiOperationTagTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
