import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementApiReleaseConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_release#api_id ApiManagementApiRelease#api_id}
    */
    readonly apiId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_release#name ApiManagementApiRelease#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_release#notes ApiManagementApiRelease#notes}
    */
    readonly notes?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_release#timeouts ApiManagementApiRelease#timeouts}
    */
    readonly timeouts?: ApiManagementApiReleaseTimeouts;
}
export interface ApiManagementApiReleaseTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_release#create ApiManagementApiRelease#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_release#delete ApiManagementApiRelease#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_release#read ApiManagementApiRelease#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_release#update ApiManagementApiRelease#update}
    */
    readonly update?: string;
}
export declare function apiManagementApiReleaseTimeoutsToTerraform(struct?: ApiManagementApiReleaseTimeoutsOutputReference | ApiManagementApiReleaseTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementApiReleaseTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ApiManagementApiReleaseTimeouts | undefined;
    set internalValue(value: ApiManagementApiReleaseTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_release azurerm_api_management_api_release}
*/
export declare class ApiManagementApiRelease extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api_release azurerm_api_management_api_release} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementApiReleaseConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementApiReleaseConfig);
    private _apiId?;
    get apiId(): string;
    set apiId(value: string);
    get apiIdInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notes?;
    get notes(): string;
    set notes(value: string);
    resetNotes(): void;
    get notesInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApiManagementApiReleaseTimeoutsOutputReference;
    putTimeouts(value: ApiManagementApiReleaseTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApiManagementApiReleaseTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
