import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementCertificateAConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate#api_management_name ApiManagementCertificateA#api_management_name}
    */
    readonly apiManagementName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate#data ApiManagementCertificateA#data}
    */
    readonly data?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate#key_vault_identity_client_id ApiManagementCertificateA#key_vault_identity_client_id}
    */
    readonly keyVaultIdentityClientId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate#key_vault_secret_id ApiManagementCertificateA#key_vault_secret_id}
    */
    readonly keyVaultSecretId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate#name ApiManagementCertificateA#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate#password ApiManagementCertificateA#password}
    */
    readonly password?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate#resource_group_name ApiManagementCertificateA#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate#timeouts ApiManagementCertificateA#timeouts}
    */
    readonly timeouts?: ApiManagementCertificateTimeouts;
}
export interface ApiManagementCertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate#create ApiManagementCertificateA#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate#delete ApiManagementCertificateA#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate#read ApiManagementCertificateA#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate#update ApiManagementCertificateA#update}
    */
    readonly update?: string;
}
export declare function apiManagementCertificateTimeoutsToTerraform(struct?: ApiManagementCertificateTimeoutsOutputReference | ApiManagementCertificateTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ApiManagementCertificateTimeouts | undefined;
    set internalValue(value: ApiManagementCertificateTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate azurerm_api_management_certificate}
*/
export declare class ApiManagementCertificateA extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate azurerm_api_management_certificate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementCertificateAConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementCertificateAConfig);
    private _apiManagementName?;
    get apiManagementName(): string;
    set apiManagementName(value: string);
    get apiManagementNameInput(): string | undefined;
    private _data?;
    get data(): string;
    set data(value: string);
    resetData(): void;
    get dataInput(): string | undefined;
    get expiration(): string;
    get id(): string;
    private _keyVaultIdentityClientId?;
    get keyVaultIdentityClientId(): string;
    set keyVaultIdentityClientId(value: string);
    resetKeyVaultIdentityClientId(): void;
    get keyVaultIdentityClientIdInput(): string | undefined;
    private _keyVaultSecretId?;
    get keyVaultSecretId(): string;
    set keyVaultSecretId(value: string);
    resetKeyVaultSecretId(): void;
    get keyVaultSecretIdInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _password?;
    get password(): string;
    set password(value: string);
    resetPassword(): void;
    get passwordInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get subject(): string;
    get thumbprint(): string;
    private _timeouts;
    get timeouts(): ApiManagementCertificateTimeoutsOutputReference;
    putTimeouts(value: ApiManagementCertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApiManagementCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
