import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApiManagementGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway#api_management_id ApiManagementGateway#api_management_id}
    */
    readonly apiManagementId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway#description ApiManagementGateway#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway#name ApiManagementGateway#name}
    */
    readonly name: string;
    /**
    * location_data block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway#location_data ApiManagementGateway#location_data}
    */
    readonly locationData: ApiManagementGatewayLocationData;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway#timeouts ApiManagementGateway#timeouts}
    */
    readonly timeouts?: ApiManagementGatewayTimeouts;
}
export interface ApiManagementGatewayLocationData {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway#city ApiManagementGateway#city}
    */
    readonly city?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway#district ApiManagementGateway#district}
    */
    readonly district?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway#name ApiManagementGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway#region ApiManagementGateway#region}
    */
    readonly region?: string;
}
export declare function apiManagementGatewayLocationDataToTerraform(struct?: ApiManagementGatewayLocationDataOutputReference | ApiManagementGatewayLocationData): any;
export declare class ApiManagementGatewayLocationDataOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ApiManagementGatewayLocationData | undefined;
    set internalValue(value: ApiManagementGatewayLocationData | undefined);
    private _city?;
    get city(): string;
    set city(value: string);
    resetCity(): void;
    get cityInput(): string | undefined;
    private _district?;
    get district(): string;
    set district(value: string);
    resetDistrict(): void;
    get districtInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
}
export interface ApiManagementGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway#create ApiManagementGateway#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway#delete ApiManagementGateway#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway#read ApiManagementGateway#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway#update ApiManagementGateway#update}
    */
    readonly update?: string;
}
export declare function apiManagementGatewayTimeoutsToTerraform(struct?: ApiManagementGatewayTimeoutsOutputReference | ApiManagementGatewayTimeouts | cdktf.IResolvable): any;
export declare class ApiManagementGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ApiManagementGatewayTimeouts | undefined;
    set internalValue(value: ApiManagementGatewayTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway azurerm_api_management_gateway}
*/
export declare class ApiManagementGateway extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_gateway azurerm_api_management_gateway} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApiManagementGatewayConfig
    */
    constructor(scope: Construct, id: string, config: ApiManagementGatewayConfig);
    private _apiManagementId?;
    get apiManagementId(): string;
    set apiManagementId(value: string);
    get apiManagementIdInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _locationData;
    get locationData(): ApiManagementGatewayLocationDataOutputReference;
    putLocationData(value: ApiManagementGatewayLocationData): void;
    get locationDataInput(): ApiManagementGatewayLocationData | undefined;
    private _timeouts;
    get timeouts(): ApiManagementGatewayTimeoutsOutputReference;
    putTimeouts(value: ApiManagementGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ApiManagementGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
