import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppServiceCertificateOrderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#auto_renew AppServiceCertificateOrder#auto_renew}
    */
    readonly autoRenew?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#csr AppServiceCertificateOrder#csr}
    */
    readonly csr?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#distinguished_name AppServiceCertificateOrder#distinguished_name}
    */
    readonly distinguishedName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#key_size AppServiceCertificateOrder#key_size}
    */
    readonly keySize?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#location AppServiceCertificateOrder#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#name AppServiceCertificateOrder#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#product_type AppServiceCertificateOrder#product_type}
    */
    readonly productType?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#resource_group_name AppServiceCertificateOrder#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#tags AppServiceCertificateOrder#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#validity_in_years AppServiceCertificateOrder#validity_in_years}
    */
    readonly validityInYears?: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#timeouts AppServiceCertificateOrder#timeouts}
    */
    readonly timeouts?: AppServiceCertificateOrderTimeouts;
}
export declare class AppServiceCertificateOrderCertificates extends cdktf.ComplexComputedList {
    get certificateName(): string;
    get keyVaultId(): string;
    get keyVaultSecretName(): string;
    get provisioningState(): string;
}
export interface AppServiceCertificateOrderTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#create AppServiceCertificateOrder#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#delete AppServiceCertificateOrder#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#read AppServiceCertificateOrder#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order#update AppServiceCertificateOrder#update}
    */
    readonly update?: string;
}
export declare function appServiceCertificateOrderTimeoutsToTerraform(struct?: AppServiceCertificateOrderTimeoutsOutputReference | AppServiceCertificateOrderTimeouts | cdktf.IResolvable): any;
export declare class AppServiceCertificateOrderTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppServiceCertificateOrderTimeouts | undefined;
    set internalValue(value: AppServiceCertificateOrderTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order azurerm_app_service_certificate_order}
*/
export declare class AppServiceCertificateOrder extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_certificate_order azurerm_app_service_certificate_order} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppServiceCertificateOrderConfig
    */
    constructor(scope: Construct, id: string, config: AppServiceCertificateOrderConfig);
    get appServiceCertificateNotRenewableReasons(): string[];
    private _autoRenew?;
    get autoRenew(): boolean | cdktf.IResolvable;
    set autoRenew(value: boolean | cdktf.IResolvable);
    resetAutoRenew(): void;
    get autoRenewInput(): boolean | cdktf.IResolvable | undefined;
    certificates(index: string): AppServiceCertificateOrderCertificates;
    private _csr?;
    get csr(): string;
    set csr(value: string);
    resetCsr(): void;
    get csrInput(): string | undefined;
    private _distinguishedName?;
    get distinguishedName(): string;
    set distinguishedName(value: string);
    resetDistinguishedName(): void;
    get distinguishedNameInput(): string | undefined;
    get domainVerificationToken(): string;
    get expirationTime(): string;
    get id(): string;
    get intermediateThumbprint(): string;
    get isPrivateKeyExternal(): cdktf.IResolvable;
    private _keySize?;
    get keySize(): number;
    set keySize(value: number);
    resetKeySize(): void;
    get keySizeInput(): number | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _productType?;
    get productType(): string;
    set productType(value: string);
    resetProductType(): void;
    get productTypeInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get rootThumbprint(): string;
    get signedCertificateThumbprint(): string;
    get status(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _validityInYears?;
    get validityInYears(): number;
    set validityInYears(value: number);
    resetValidityInYears(): void;
    get validityInYearsInput(): number | undefined;
    private _timeouts;
    get timeouts(): AppServiceCertificateOrderTimeoutsOutputReference;
    putTimeouts(value: AppServiceCertificateOrderTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): AppServiceCertificateOrderTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
