import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AppServiceEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment#allowed_user_ip_cidrs AppServiceEnvironment#allowed_user_ip_cidrs}
    */
    readonly allowedUserIpCidrs?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment#front_end_scale_factor AppServiceEnvironment#front_end_scale_factor}
    */
    readonly frontEndScaleFactor?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment#internal_load_balancing_mode AppServiceEnvironment#internal_load_balancing_mode}
    */
    readonly internalLoadBalancingMode?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment#name AppServiceEnvironment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment#pricing_tier AppServiceEnvironment#pricing_tier}
    */
    readonly pricingTier?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment#resource_group_name AppServiceEnvironment#resource_group_name}
    */
    readonly resourceGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment#subnet_id AppServiceEnvironment#subnet_id}
    */
    readonly subnetId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment#tags AppServiceEnvironment#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment#user_whitelisted_ip_ranges AppServiceEnvironment#user_whitelisted_ip_ranges}
    */
    readonly userWhitelistedIpRanges?: string[];
    /**
    * cluster_setting block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment#cluster_setting AppServiceEnvironment#cluster_setting}
    */
    readonly clusterSetting?: AppServiceEnvironmentClusterSetting[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment#timeouts AppServiceEnvironment#timeouts}
    */
    readonly timeouts?: AppServiceEnvironmentTimeouts;
}
export interface AppServiceEnvironmentClusterSetting {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment#name AppServiceEnvironment#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment#value AppServiceEnvironment#value}
    */
    readonly value: string;
}
export declare function appServiceEnvironmentClusterSettingToTerraform(struct?: AppServiceEnvironmentClusterSetting | cdktf.IResolvable): any;
export interface AppServiceEnvironmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment#create AppServiceEnvironment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment#delete AppServiceEnvironment#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment#read AppServiceEnvironment#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment#update AppServiceEnvironment#update}
    */
    readonly update?: string;
}
export declare function appServiceEnvironmentTimeoutsToTerraform(struct?: AppServiceEnvironmentTimeoutsOutputReference | AppServiceEnvironmentTimeouts | cdktf.IResolvable): any;
export declare class AppServiceEnvironmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AppServiceEnvironmentTimeouts | undefined;
    set internalValue(value: AppServiceEnvironmentTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment azurerm_app_service_environment}
*/
export declare class AppServiceEnvironment extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/app_service_environment azurerm_app_service_environment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AppServiceEnvironmentConfig
    */
    constructor(scope: Construct, id: string, config: AppServiceEnvironmentConfig);
    private _allowedUserIpCidrs?;
    get allowedUserIpCidrs(): string[];
    set allowedUserIpCidrs(value: string[]);
    resetAllowedUserIpCidrs(): void;
    get allowedUserIpCidrsInput(): string[] | undefined;
    private _frontEndScaleFactor?;
    get frontEndScaleFactor(): number;
    set frontEndScaleFactor(value: number);
    resetFrontEndScaleFactor(): void;
    get frontEndScaleFactorInput(): number | undefined;
    get id(): string;
    get internalIpAddress(): string;
    private _internalLoadBalancingMode?;
    get internalLoadBalancingMode(): string;
    set internalLoadBalancingMode(value: string);
    resetInternalLoadBalancingMode(): void;
    get internalLoadBalancingModeInput(): string | undefined;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIpAddresses(): string[];
    private _pricingTier?;
    get pricingTier(): string;
    set pricingTier(value: string);
    resetPricingTier(): void;
    get pricingTierInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    resetResourceGroupName(): void;
    get resourceGroupNameInput(): string | undefined;
    get serviceIpAddress(): string;
    private _subnetId?;
    get subnetId(): string;
    set subnetId(value: string);
    get subnetIdInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _userWhitelistedIpRanges?;
    get userWhitelistedIpRanges(): string[];
    set userWhitelistedIpRanges(value: string[]);
    resetUserWhitelistedIpRanges(): void;
    get userWhitelistedIpRangesInput(): string[] | undefined;
    private _clusterSetting?;
    get clusterSetting(): AppServiceEnvironmentClusterSetting[] | cdktf.IResolvable;
    set clusterSetting(value: AppServiceEnvironmentClusterSetting[] | cdktf.IResolvable);
    resetClusterSetting(): void;
    get clusterSettingInput(): cdktf.IResolvable | AppServiceEnvironmentClusterSetting[] | undefined;
    private _timeouts;
    get timeouts(): AppServiceEnvironmentTimeoutsOutputReference;
    putTimeouts(value: AppServiceEnvironmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): AppServiceEnvironmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
