import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BackupContainerStorageAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_container_storage_account#recovery_vault_name BackupContainerStorageAccount#recovery_vault_name}
    */
    readonly recoveryVaultName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_container_storage_account#resource_group_name BackupContainerStorageAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_container_storage_account#storage_account_id BackupContainerStorageAccount#storage_account_id}
    */
    readonly storageAccountId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_container_storage_account#timeouts BackupContainerStorageAccount#timeouts}
    */
    readonly timeouts?: BackupContainerStorageAccountTimeouts;
}
export interface BackupContainerStorageAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_container_storage_account#create BackupContainerStorageAccount#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_container_storage_account#delete BackupContainerStorageAccount#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_container_storage_account#read BackupContainerStorageAccount#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/backup_container_storage_account#update BackupContainerStorageAccount#update}
    */
    readonly update?: string;
}
export declare function backupContainerStorageAccountTimeoutsToTerraform(struct?: BackupContainerStorageAccountTimeoutsOutputReference | BackupContainerStorageAccountTimeouts | cdktf.IResolvable): any;
export declare class BackupContainerStorageAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): BackupContainerStorageAccountTimeouts | undefined;
    set internalValue(value: BackupContainerStorageAccountTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/backup_container_storage_account azurerm_backup_container_storage_account}
*/
export declare class BackupContainerStorageAccount extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/backup_container_storage_account azurerm_backup_container_storage_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BackupContainerStorageAccountConfig
    */
    constructor(scope: Construct, id: string, config: BackupContainerStorageAccountConfig);
    get id(): string;
    private _recoveryVaultName?;
    get recoveryVaultName(): string;
    set recoveryVaultName(value: string);
    get recoveryVaultNameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _storageAccountId?;
    get storageAccountId(): string;
    set storageAccountId(value: string);
    get storageAccountIdInput(): string | undefined;
    private _timeouts;
    get timeouts(): BackupContainerStorageAccountTimeoutsOutputReference;
    putTimeouts(value: BackupContainerStorageAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): BackupContainerStorageAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
