import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ContainerRegistryScopeMapConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_scope_map#actions ContainerRegistryScopeMap#actions}
    */
    readonly actions: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_scope_map#container_registry_name ContainerRegistryScopeMap#container_registry_name}
    */
    readonly containerRegistryName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_scope_map#description ContainerRegistryScopeMap#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_scope_map#name ContainerRegistryScopeMap#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_scope_map#resource_group_name ContainerRegistryScopeMap#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_scope_map#timeouts ContainerRegistryScopeMap#timeouts}
    */
    readonly timeouts?: ContainerRegistryScopeMapTimeouts;
}
export interface ContainerRegistryScopeMapTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_scope_map#create ContainerRegistryScopeMap#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_scope_map#delete ContainerRegistryScopeMap#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_scope_map#read ContainerRegistryScopeMap#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_scope_map#update ContainerRegistryScopeMap#update}
    */
    readonly update?: string;
}
export declare function containerRegistryScopeMapTimeoutsToTerraform(struct?: ContainerRegistryScopeMapTimeoutsOutputReference | ContainerRegistryScopeMapTimeouts | cdktf.IResolvable): any;
export declare class ContainerRegistryScopeMapTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ContainerRegistryScopeMapTimeouts | undefined;
    set internalValue(value: ContainerRegistryScopeMapTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_scope_map azurerm_container_registry_scope_map}
*/
export declare class ContainerRegistryScopeMap extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry_scope_map azurerm_container_registry_scope_map} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ContainerRegistryScopeMapConfig
    */
    constructor(scope: Construct, id: string, config: ContainerRegistryScopeMapConfig);
    private _actions?;
    get actions(): string[];
    set actions(value: string[]);
    get actionsInput(): string[] | undefined;
    private _containerRegistryName?;
    get containerRegistryName(): string;
    set containerRegistryName(value: string);
    get containerRegistryNameInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): ContainerRegistryScopeMapTimeoutsOutputReference;
    putTimeouts(value: ContainerRegistryScopeMapTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): ContainerRegistryScopeMapTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
