import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CosmosdbSqlContainerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#account_name CosmosdbSqlContainer#account_name}
    */
    readonly accountName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#analytical_storage_ttl CosmosdbSqlContainer#analytical_storage_ttl}
    */
    readonly analyticalStorageTtl?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#database_name CosmosdbSqlContainer#database_name}
    */
    readonly databaseName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#default_ttl CosmosdbSqlContainer#default_ttl}
    */
    readonly defaultTtl?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#name CosmosdbSqlContainer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#partition_key_path CosmosdbSqlContainer#partition_key_path}
    */
    readonly partitionKeyPath: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#partition_key_version CosmosdbSqlContainer#partition_key_version}
    */
    readonly partitionKeyVersion?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#resource_group_name CosmosdbSqlContainer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#throughput CosmosdbSqlContainer#throughput}
    */
    readonly throughput?: number;
    /**
    * autoscale_settings block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#autoscale_settings CosmosdbSqlContainer#autoscale_settings}
    */
    readonly autoscaleSettings?: CosmosdbSqlContainerAutoscaleSettings;
    /**
    * conflict_resolution_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#conflict_resolution_policy CosmosdbSqlContainer#conflict_resolution_policy}
    */
    readonly conflictResolutionPolicy?: CosmosdbSqlContainerConflictResolutionPolicy;
    /**
    * indexing_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#indexing_policy CosmosdbSqlContainer#indexing_policy}
    */
    readonly indexingPolicy?: CosmosdbSqlContainerIndexingPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#timeouts CosmosdbSqlContainer#timeouts}
    */
    readonly timeouts?: CosmosdbSqlContainerTimeouts;
    /**
    * unique_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#unique_key CosmosdbSqlContainer#unique_key}
    */
    readonly uniqueKey?: CosmosdbSqlContainerUniqueKey[] | cdktf.IResolvable;
}
export interface CosmosdbSqlContainerAutoscaleSettings {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#max_throughput CosmosdbSqlContainer#max_throughput}
    */
    readonly maxThroughput?: number;
}
export declare function cosmosdbSqlContainerAutoscaleSettingsToTerraform(struct?: CosmosdbSqlContainerAutoscaleSettingsOutputReference | CosmosdbSqlContainerAutoscaleSettings): any;
export declare class CosmosdbSqlContainerAutoscaleSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CosmosdbSqlContainerAutoscaleSettings | undefined;
    set internalValue(value: CosmosdbSqlContainerAutoscaleSettings | undefined);
    private _maxThroughput?;
    get maxThroughput(): number;
    set maxThroughput(value: number);
    resetMaxThroughput(): void;
    get maxThroughputInput(): number | undefined;
}
export interface CosmosdbSqlContainerConflictResolutionPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#conflict_resolution_path CosmosdbSqlContainer#conflict_resolution_path}
    */
    readonly conflictResolutionPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#conflict_resolution_procedure CosmosdbSqlContainer#conflict_resolution_procedure}
    */
    readonly conflictResolutionProcedure?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#mode CosmosdbSqlContainer#mode}
    */
    readonly mode: string;
}
export declare function cosmosdbSqlContainerConflictResolutionPolicyToTerraform(struct?: CosmosdbSqlContainerConflictResolutionPolicyOutputReference | CosmosdbSqlContainerConflictResolutionPolicy): any;
export declare class CosmosdbSqlContainerConflictResolutionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CosmosdbSqlContainerConflictResolutionPolicy | undefined;
    set internalValue(value: CosmosdbSqlContainerConflictResolutionPolicy | undefined);
    private _conflictResolutionPath?;
    get conflictResolutionPath(): string;
    set conflictResolutionPath(value: string);
    resetConflictResolutionPath(): void;
    get conflictResolutionPathInput(): string | undefined;
    private _conflictResolutionProcedure?;
    get conflictResolutionProcedure(): string;
    set conflictResolutionProcedure(value: string);
    resetConflictResolutionProcedure(): void;
    get conflictResolutionProcedureInput(): string | undefined;
    private _mode?;
    get mode(): string;
    set mode(value: string);
    get modeInput(): string | undefined;
}
export interface CosmosdbSqlContainerIndexingPolicyCompositeIndexIndex {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#order CosmosdbSqlContainer#order}
    */
    readonly order: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#path CosmosdbSqlContainer#path}
    */
    readonly path: string;
}
export declare function cosmosdbSqlContainerIndexingPolicyCompositeIndexIndexToTerraform(struct?: CosmosdbSqlContainerIndexingPolicyCompositeIndexIndex | cdktf.IResolvable): any;
export interface CosmosdbSqlContainerIndexingPolicyCompositeIndex {
    /**
    * index block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#index CosmosdbSqlContainer#index}
    */
    readonly index: CosmosdbSqlContainerIndexingPolicyCompositeIndexIndex[] | cdktf.IResolvable;
}
export declare function cosmosdbSqlContainerIndexingPolicyCompositeIndexToTerraform(struct?: CosmosdbSqlContainerIndexingPolicyCompositeIndex | cdktf.IResolvable): any;
export interface CosmosdbSqlContainerIndexingPolicyExcludedPath {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#path CosmosdbSqlContainer#path}
    */
    readonly path: string;
}
export declare function cosmosdbSqlContainerIndexingPolicyExcludedPathToTerraform(struct?: CosmosdbSqlContainerIndexingPolicyExcludedPath | cdktf.IResolvable): any;
export interface CosmosdbSqlContainerIndexingPolicyIncludedPath {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#path CosmosdbSqlContainer#path}
    */
    readonly path: string;
}
export declare function cosmosdbSqlContainerIndexingPolicyIncludedPathToTerraform(struct?: CosmosdbSqlContainerIndexingPolicyIncludedPath | cdktf.IResolvable): any;
export interface CosmosdbSqlContainerIndexingPolicySpatialIndex {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#path CosmosdbSqlContainer#path}
    */
    readonly path: string;
}
export declare function cosmosdbSqlContainerIndexingPolicySpatialIndexToTerraform(struct?: CosmosdbSqlContainerIndexingPolicySpatialIndex | cdktf.IResolvable): any;
export interface CosmosdbSqlContainerIndexingPolicy {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#indexing_mode CosmosdbSqlContainer#indexing_mode}
    */
    readonly indexingMode?: string;
    /**
    * composite_index block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#composite_index CosmosdbSqlContainer#composite_index}
    */
    readonly compositeIndex?: CosmosdbSqlContainerIndexingPolicyCompositeIndex[] | cdktf.IResolvable;
    /**
    * excluded_path block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#excluded_path CosmosdbSqlContainer#excluded_path}
    */
    readonly excludedPath?: CosmosdbSqlContainerIndexingPolicyExcludedPath[] | cdktf.IResolvable;
    /**
    * included_path block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#included_path CosmosdbSqlContainer#included_path}
    */
    readonly includedPath?: CosmosdbSqlContainerIndexingPolicyIncludedPath[] | cdktf.IResolvable;
    /**
    * spatial_index block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#spatial_index CosmosdbSqlContainer#spatial_index}
    */
    readonly spatialIndex?: CosmosdbSqlContainerIndexingPolicySpatialIndex[] | cdktf.IResolvable;
}
export declare function cosmosdbSqlContainerIndexingPolicyToTerraform(struct?: CosmosdbSqlContainerIndexingPolicyOutputReference | CosmosdbSqlContainerIndexingPolicy): any;
export declare class CosmosdbSqlContainerIndexingPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CosmosdbSqlContainerIndexingPolicy | undefined;
    set internalValue(value: CosmosdbSqlContainerIndexingPolicy | undefined);
    private _indexingMode?;
    get indexingMode(): string;
    set indexingMode(value: string);
    resetIndexingMode(): void;
    get indexingModeInput(): string | undefined;
    private _compositeIndex?;
    get compositeIndex(): CosmosdbSqlContainerIndexingPolicyCompositeIndex[] | cdktf.IResolvable;
    set compositeIndex(value: CosmosdbSqlContainerIndexingPolicyCompositeIndex[] | cdktf.IResolvable);
    resetCompositeIndex(): void;
    get compositeIndexInput(): cdktf.IResolvable | CosmosdbSqlContainerIndexingPolicyCompositeIndex[] | undefined;
    private _excludedPath?;
    get excludedPath(): CosmosdbSqlContainerIndexingPolicyExcludedPath[] | cdktf.IResolvable;
    set excludedPath(value: CosmosdbSqlContainerIndexingPolicyExcludedPath[] | cdktf.IResolvable);
    resetExcludedPath(): void;
    get excludedPathInput(): cdktf.IResolvable | CosmosdbSqlContainerIndexingPolicyExcludedPath[] | undefined;
    private _includedPath?;
    get includedPath(): CosmosdbSqlContainerIndexingPolicyIncludedPath[] | cdktf.IResolvable;
    set includedPath(value: CosmosdbSqlContainerIndexingPolicyIncludedPath[] | cdktf.IResolvable);
    resetIncludedPath(): void;
    get includedPathInput(): cdktf.IResolvable | CosmosdbSqlContainerIndexingPolicyIncludedPath[] | undefined;
    private _spatialIndex?;
    get spatialIndex(): CosmosdbSqlContainerIndexingPolicySpatialIndex[] | cdktf.IResolvable;
    set spatialIndex(value: CosmosdbSqlContainerIndexingPolicySpatialIndex[] | cdktf.IResolvable);
    resetSpatialIndex(): void;
    get spatialIndexInput(): cdktf.IResolvable | CosmosdbSqlContainerIndexingPolicySpatialIndex[] | undefined;
}
export interface CosmosdbSqlContainerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#create CosmosdbSqlContainer#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#delete CosmosdbSqlContainer#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#read CosmosdbSqlContainer#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#update CosmosdbSqlContainer#update}
    */
    readonly update?: string;
}
export declare function cosmosdbSqlContainerTimeoutsToTerraform(struct?: CosmosdbSqlContainerTimeoutsOutputReference | CosmosdbSqlContainerTimeouts | cdktf.IResolvable): any;
export declare class CosmosdbSqlContainerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CosmosdbSqlContainerTimeouts | undefined;
    set internalValue(value: CosmosdbSqlContainerTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface CosmosdbSqlContainerUniqueKey {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container#paths CosmosdbSqlContainer#paths}
    */
    readonly paths: string[];
}
export declare function cosmosdbSqlContainerUniqueKeyToTerraform(struct?: CosmosdbSqlContainerUniqueKey | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container azurerm_cosmosdb_sql_container}
*/
export declare class CosmosdbSqlContainer extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/cosmosdb_sql_container azurerm_cosmosdb_sql_container} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CosmosdbSqlContainerConfig
    */
    constructor(scope: Construct, id: string, config: CosmosdbSqlContainerConfig);
    private _accountName?;
    get accountName(): string;
    set accountName(value: string);
    get accountNameInput(): string | undefined;
    private _analyticalStorageTtl?;
    get analyticalStorageTtl(): number;
    set analyticalStorageTtl(value: number);
    resetAnalyticalStorageTtl(): void;
    get analyticalStorageTtlInput(): number | undefined;
    private _databaseName?;
    get databaseName(): string;
    set databaseName(value: string);
    get databaseNameInput(): string | undefined;
    private _defaultTtl?;
    get defaultTtl(): number;
    set defaultTtl(value: number);
    resetDefaultTtl(): void;
    get defaultTtlInput(): number | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _partitionKeyPath?;
    get partitionKeyPath(): string;
    set partitionKeyPath(value: string);
    get partitionKeyPathInput(): string | undefined;
    private _partitionKeyVersion?;
    get partitionKeyVersion(): number;
    set partitionKeyVersion(value: number);
    resetPartitionKeyVersion(): void;
    get partitionKeyVersionInput(): number | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _throughput?;
    get throughput(): number;
    set throughput(value: number);
    resetThroughput(): void;
    get throughputInput(): number | undefined;
    private _autoscaleSettings;
    get autoscaleSettings(): CosmosdbSqlContainerAutoscaleSettingsOutputReference;
    putAutoscaleSettings(value: CosmosdbSqlContainerAutoscaleSettings): void;
    resetAutoscaleSettings(): void;
    get autoscaleSettingsInput(): CosmosdbSqlContainerAutoscaleSettings | undefined;
    private _conflictResolutionPolicy;
    get conflictResolutionPolicy(): CosmosdbSqlContainerConflictResolutionPolicyOutputReference;
    putConflictResolutionPolicy(value: CosmosdbSqlContainerConflictResolutionPolicy): void;
    resetConflictResolutionPolicy(): void;
    get conflictResolutionPolicyInput(): CosmosdbSqlContainerConflictResolutionPolicy | undefined;
    private _indexingPolicy;
    get indexingPolicy(): CosmosdbSqlContainerIndexingPolicyOutputReference;
    putIndexingPolicy(value: CosmosdbSqlContainerIndexingPolicy): void;
    resetIndexingPolicy(): void;
    get indexingPolicyInput(): CosmosdbSqlContainerIndexingPolicy | undefined;
    private _timeouts;
    get timeouts(): CosmosdbSqlContainerTimeoutsOutputReference;
    putTimeouts(value: CosmosdbSqlContainerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CosmosdbSqlContainerTimeouts | undefined;
    private _uniqueKey?;
    get uniqueKey(): CosmosdbSqlContainerUniqueKey[] | cdktf.IResolvable;
    set uniqueKey(value: CosmosdbSqlContainerUniqueKey[] | cdktf.IResolvable);
    resetUniqueKey(): void;
    get uniqueKeyInput(): cdktf.IResolvable | CosmosdbSqlContainerUniqueKey[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
