import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CustomProviderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/custom_provider#location CustomProvider#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/custom_provider#name CustomProvider#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/custom_provider#resource_group_name CustomProvider#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/custom_provider#tags CustomProvider#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/custom_provider#action CustomProvider#action}
    */
    readonly action?: CustomProviderAction[] | cdktf.IResolvable;
    /**
    * resource_type block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/custom_provider#resource_type CustomProvider#resource_type}
    */
    readonly resourceType?: CustomProviderResourceType[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/custom_provider#timeouts CustomProvider#timeouts}
    */
    readonly timeouts?: CustomProviderTimeouts;
    /**
    * validation block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/custom_provider#validation CustomProvider#validation}
    */
    readonly validation?: CustomProviderValidation[] | cdktf.IResolvable;
}
export interface CustomProviderAction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/custom_provider#endpoint CustomProvider#endpoint}
    */
    readonly endpoint: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/custom_provider#name CustomProvider#name}
    */
    readonly name: string;
}
export declare function customProviderActionToTerraform(struct?: CustomProviderAction | cdktf.IResolvable): any;
export interface CustomProviderResourceType {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/custom_provider#endpoint CustomProvider#endpoint}
    */
    readonly endpoint: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/custom_provider#name CustomProvider#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/custom_provider#routing_type CustomProvider#routing_type}
    */
    readonly routingType?: string;
}
export declare function customProviderResourceTypeToTerraform(struct?: CustomProviderResourceType | cdktf.IResolvable): any;
export interface CustomProviderTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/custom_provider#create CustomProvider#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/custom_provider#delete CustomProvider#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/custom_provider#read CustomProvider#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/custom_provider#update CustomProvider#update}
    */
    readonly update?: string;
}
export declare function customProviderTimeoutsToTerraform(struct?: CustomProviderTimeoutsOutputReference | CustomProviderTimeouts | cdktf.IResolvable): any;
export declare class CustomProviderTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CustomProviderTimeouts | undefined;
    set internalValue(value: CustomProviderTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface CustomProviderValidation {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/custom_provider#specification CustomProvider#specification}
    */
    readonly specification: string;
}
export declare function customProviderValidationToTerraform(struct?: CustomProviderValidation | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/custom_provider azurerm_custom_provider}
*/
export declare class CustomProvider extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/custom_provider azurerm_custom_provider} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CustomProviderConfig
    */
    constructor(scope: Construct, id: string, config: CustomProviderConfig);
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _action?;
    get action(): CustomProviderAction[] | cdktf.IResolvable;
    set action(value: CustomProviderAction[] | cdktf.IResolvable);
    resetAction(): void;
    get actionInput(): cdktf.IResolvable | CustomProviderAction[] | undefined;
    private _resourceType?;
    get resourceType(): CustomProviderResourceType[] | cdktf.IResolvable;
    set resourceType(value: CustomProviderResourceType[] | cdktf.IResolvable);
    resetResourceType(): void;
    get resourceTypeInput(): cdktf.IResolvable | CustomProviderResourceType[] | undefined;
    private _timeouts;
    get timeouts(): CustomProviderTimeoutsOutputReference;
    putTimeouts(value: CustomProviderTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CustomProviderTimeouts | undefined;
    private _validation?;
    get validation(): CustomProviderValidation[] | cdktf.IResolvable;
    set validation(value: CustomProviderValidation[] | cdktf.IResolvable);
    resetValidation(): void;
    get validationInput(): cdktf.IResolvable | CustomProviderValidation[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
