import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermActiveDirectoryDomainServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/active_directory_domain_service#name DataAzurermActiveDirectoryDomainService#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/active_directory_domain_service#resource_group_name DataAzurermActiveDirectoryDomainService#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/active_directory_domain_service#timeouts DataAzurermActiveDirectoryDomainService#timeouts}
    */
    readonly timeouts?: DataAzurermActiveDirectoryDomainServiceTimeouts;
}
export declare class DataAzurermActiveDirectoryDomainServiceNotifications extends cdktf.ComplexComputedList {
    get additionalRecipients(): string[];
    get notifyDcAdmins(): cdktf.IResolvable;
    get notifyGlobalAdmins(): cdktf.IResolvable;
}
export declare class DataAzurermActiveDirectoryDomainServiceReplicaSets extends cdktf.ComplexComputedList {
    get domainControllerIpAddresses(): string[];
    get externalAccessIpAddress(): string;
    get id(): string;
    get location(): string;
    get serviceStatus(): string;
    get subnetId(): string;
}
export declare class DataAzurermActiveDirectoryDomainServiceSecureLdap extends cdktf.ComplexComputedList {
    get certificateExpiry(): string;
    get certificateThumbprint(): string;
    get enabled(): cdktf.IResolvable;
    get externalAccessEnabled(): cdktf.IResolvable;
    get publicCertificate(): string;
}
export declare class DataAzurermActiveDirectoryDomainServiceSecurity extends cdktf.ComplexComputedList {
    get ntlmV1Enabled(): cdktf.IResolvable;
    get syncKerberosPasswords(): cdktf.IResolvable;
    get syncNtlmPasswords(): cdktf.IResolvable;
    get syncOnPremPasswords(): cdktf.IResolvable;
    get tlsV1Enabled(): cdktf.IResolvable;
}
export interface DataAzurermActiveDirectoryDomainServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/active_directory_domain_service#read DataAzurermActiveDirectoryDomainService#read}
    */
    readonly read?: string;
}
export declare function dataAzurermActiveDirectoryDomainServiceTimeoutsToTerraform(struct?: DataAzurermActiveDirectoryDomainServiceTimeoutsOutputReference | DataAzurermActiveDirectoryDomainServiceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermActiveDirectoryDomainServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermActiveDirectoryDomainServiceTimeouts | undefined;
    set internalValue(value: DataAzurermActiveDirectoryDomainServiceTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/active_directory_domain_service azurerm_active_directory_domain_service}
*/
export declare class DataAzurermActiveDirectoryDomainService extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/active_directory_domain_service azurerm_active_directory_domain_service} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermActiveDirectoryDomainServiceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermActiveDirectoryDomainServiceConfig);
    get deploymentId(): string;
    get domainConfigurationType(): string;
    get domainName(): string;
    get filteredSyncEnabled(): cdktf.IResolvable;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    notifications(index: string): DataAzurermActiveDirectoryDomainServiceNotifications;
    replicaSets(index: string): DataAzurermActiveDirectoryDomainServiceReplicaSets;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get resourceId(): string;
    secureLdap(index: string): DataAzurermActiveDirectoryDomainServiceSecureLdap;
    security(index: string): DataAzurermActiveDirectoryDomainServiceSecurity;
    get sku(): string;
    get syncOwner(): string;
    tags(key: string): string | cdktf.IResolvable;
    get tenantId(): string;
    get version(): number;
    private _timeouts;
    get timeouts(): DataAzurermActiveDirectoryDomainServiceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermActiveDirectoryDomainServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermActiveDirectoryDomainServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
