import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAdvisorRecommendationsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/advisor_recommendations#filter_by_category DataAzurermAdvisorRecommendations#filter_by_category}
    */
    readonly filterByCategory?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/advisor_recommendations#filter_by_resource_groups DataAzurermAdvisorRecommendations#filter_by_resource_groups}
    */
    readonly filterByResourceGroups?: string[];
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/advisor_recommendations#timeouts DataAzurermAdvisorRecommendations#timeouts}
    */
    readonly timeouts?: DataAzurermAdvisorRecommendationsTimeouts;
}
export declare class DataAzurermAdvisorRecommendationsRecommendations extends cdktf.ComplexComputedList {
    get category(): string;
    get description(): string;
    get impact(): string;
    get recommendationName(): string;
    get recommendationTypeId(): string;
    get resourceName(): string;
    get resourceType(): string;
    get suppressionNames(): string[];
    get updatedTime(): string;
}
export interface DataAzurermAdvisorRecommendationsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/advisor_recommendations#read DataAzurermAdvisorRecommendations#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAdvisorRecommendationsTimeoutsToTerraform(struct?: DataAzurermAdvisorRecommendationsTimeoutsOutputReference | DataAzurermAdvisorRecommendationsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAdvisorRecommendationsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermAdvisorRecommendationsTimeouts | undefined;
    set internalValue(value: DataAzurermAdvisorRecommendationsTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/advisor_recommendations azurerm_advisor_recommendations}
*/
export declare class DataAzurermAdvisorRecommendations extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/advisor_recommendations azurerm_advisor_recommendations} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAdvisorRecommendationsConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzurermAdvisorRecommendationsConfig);
    private _filterByCategory?;
    get filterByCategory(): string[];
    set filterByCategory(value: string[]);
    resetFilterByCategory(): void;
    get filterByCategoryInput(): string[] | undefined;
    private _filterByResourceGroups?;
    get filterByResourceGroups(): string[];
    set filterByResourceGroups(value: string[]);
    resetFilterByResourceGroups(): void;
    get filterByResourceGroupsInput(): string[] | undefined;
    get id(): string;
    recommendations(index: string): DataAzurermAdvisorRecommendationsRecommendations;
    private _timeouts;
    get timeouts(): DataAzurermAdvisorRecommendationsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAdvisorRecommendationsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermAdvisorRecommendationsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
