import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermApiManagementConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management#name DataAzurermApiManagement#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management#resource_group_name DataAzurermApiManagement#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management#timeouts DataAzurermApiManagement#timeouts}
    */
    readonly timeouts?: DataAzurermApiManagementTimeouts;
}
export declare class DataAzurermApiManagementAdditionalLocation extends cdktf.ComplexComputedList {
    get capacity(): number;
    get gatewayRegionalUrl(): string;
    get location(): string;
    get privateIpAddresses(): string[];
    get publicIpAddressId(): string;
    get publicIpAddresses(): string[];
    get zones(): string[];
}
export declare class DataAzurermApiManagementHostnameConfigurationDeveloperPortal extends cdktf.ComplexComputedList {
    get hostName(): string;
    get keyVaultId(): string;
    get negotiateClientCertificate(): cdktf.IResolvable;
}
export declare class DataAzurermApiManagementHostnameConfigurationManagement extends cdktf.ComplexComputedList {
    get hostName(): string;
    get keyVaultId(): string;
    get negotiateClientCertificate(): cdktf.IResolvable;
}
export declare class DataAzurermApiManagementHostnameConfigurationPortal extends cdktf.ComplexComputedList {
    get hostName(): string;
    get keyVaultId(): string;
    get negotiateClientCertificate(): cdktf.IResolvable;
}
export declare class DataAzurermApiManagementHostnameConfigurationProxy extends cdktf.ComplexComputedList {
    get defaultSslBinding(): cdktf.IResolvable;
    get hostName(): string;
    get keyVaultId(): string;
    get negotiateClientCertificate(): cdktf.IResolvable;
}
export declare class DataAzurermApiManagementHostnameConfigurationScm extends cdktf.ComplexComputedList {
    get hostName(): string;
    get keyVaultId(): string;
    get negotiateClientCertificate(): cdktf.IResolvable;
}
export declare class DataAzurermApiManagementHostnameConfiguration extends cdktf.ComplexComputedList {
    get developerPortal(): cdktf.IResolvable;
    get management(): cdktf.IResolvable;
    get portal(): cdktf.IResolvable;
    get proxy(): cdktf.IResolvable;
    get scm(): cdktf.IResolvable;
}
export declare class DataAzurermApiManagementIdentity extends cdktf.ComplexComputedList {
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export interface DataAzurermApiManagementTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/api_management#read DataAzurermApiManagement#read}
    */
    readonly read?: string;
}
export declare function dataAzurermApiManagementTimeoutsToTerraform(struct?: DataAzurermApiManagementTimeoutsOutputReference | DataAzurermApiManagementTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermApiManagementTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermApiManagementTimeouts | undefined;
    set internalValue(value: DataAzurermApiManagementTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/api_management azurerm_api_management}
*/
export declare class DataAzurermApiManagement extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/api_management azurerm_api_management} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermApiManagementConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermApiManagementConfig);
    additionalLocation(index: string): DataAzurermApiManagementAdditionalLocation;
    get developerPortalUrl(): string;
    get gatewayRegionalUrl(): string;
    get gatewayUrl(): string;
    hostnameConfiguration(index: string): DataAzurermApiManagementHostnameConfiguration;
    get id(): string;
    identity(index: string): DataAzurermApiManagementIdentity;
    get location(): string;
    get managementApiUrl(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get notificationSenderEmail(): string;
    get portalUrl(): string;
    get privateIpAddresses(): string[];
    get publicIpAddressId(): string;
    get publicIpAddresses(): string[];
    get publisherEmail(): string;
    get publisherName(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get scmUrl(): string;
    get skuName(): string;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermApiManagementTimeoutsOutputReference;
    putTimeouts(value: DataAzurermApiManagementTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermApiManagementTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
