import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAppConfigurationKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration_key#configuration_store_id DataAzurermAppConfigurationKey#configuration_store_id}
    */
    readonly configurationStoreId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration_key#key DataAzurermAppConfigurationKey#key}
    */
    readonly key: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration_key#label DataAzurermAppConfigurationKey#label}
    */
    readonly label?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration_key#timeouts DataAzurermAppConfigurationKey#timeouts}
    */
    readonly timeouts?: DataAzurermAppConfigurationKeyTimeouts;
}
export interface DataAzurermAppConfigurationKeyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration_key#read DataAzurermAppConfigurationKey#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAppConfigurationKeyTimeoutsToTerraform(struct?: DataAzurermAppConfigurationKeyTimeoutsOutputReference | DataAzurermAppConfigurationKeyTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAppConfigurationKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermAppConfigurationKeyTimeouts | undefined;
    set internalValue(value: DataAzurermAppConfigurationKeyTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration_key azurerm_app_configuration_key}
*/
export declare class DataAzurermAppConfigurationKey extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration_key azurerm_app_configuration_key} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAppConfigurationKeyConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermAppConfigurationKeyConfig);
    private _configurationStoreId?;
    get configurationStoreId(): string;
    set configurationStoreId(value: string);
    get configurationStoreIdInput(): string | undefined;
    get contentType(): string;
    get etag(): string;
    get id(): string;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _label?;
    get label(): string;
    set label(value: string);
    resetLabel(): void;
    get labelInput(): string | undefined;
    get locked(): cdktf.IResolvable;
    tags(key: string): string | cdktf.IResolvable;
    get type(): string;
    get value(): string;
    get vaultKeyReference(): string;
    private _timeouts;
    get timeouts(): DataAzurermAppConfigurationKeyTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAppConfigurationKeyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermAppConfigurationKeyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
