import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAppServiceCertificateOrderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_certificate_order#name DataAzurermAppServiceCertificateOrder#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_certificate_order#resource_group_name DataAzurermAppServiceCertificateOrder#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_certificate_order#timeouts DataAzurermAppServiceCertificateOrder#timeouts}
    */
    readonly timeouts?: DataAzurermAppServiceCertificateOrderTimeouts;
}
export declare class DataAzurermAppServiceCertificateOrderCertificates extends cdktf.ComplexComputedList {
    get certificateName(): string;
    get keyVaultId(): string;
    get keyVaultSecretName(): string;
    get provisioningState(): string;
}
export interface DataAzurermAppServiceCertificateOrderTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_certificate_order#read DataAzurermAppServiceCertificateOrder#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAppServiceCertificateOrderTimeoutsToTerraform(struct?: DataAzurermAppServiceCertificateOrderTimeoutsOutputReference | DataAzurermAppServiceCertificateOrderTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAppServiceCertificateOrderTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermAppServiceCertificateOrderTimeouts | undefined;
    set internalValue(value: DataAzurermAppServiceCertificateOrderTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_certificate_order azurerm_app_service_certificate_order}
*/
export declare class DataAzurermAppServiceCertificateOrder extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_certificate_order azurerm_app_service_certificate_order} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAppServiceCertificateOrderConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermAppServiceCertificateOrderConfig);
    get appServiceCertificateNotRenewableReasons(): string[];
    get autoRenew(): cdktf.IResolvable;
    certificates(index: string): DataAzurermAppServiceCertificateOrderCertificates;
    get csr(): string;
    get distinguishedName(): string;
    get domainVerificationToken(): string;
    get expirationTime(): string;
    get id(): string;
    get intermediateThumbprint(): string;
    get isPrivateKeyExternal(): cdktf.IResolvable;
    get keySize(): number;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get productType(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get rootThumbprint(): string;
    get signedCertificateThumbprint(): string;
    get status(): string;
    tags(key: string): string | cdktf.IResolvable;
    get validityInYears(): number;
    private _timeouts;
    get timeouts(): DataAzurermAppServiceCertificateOrderTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAppServiceCertificateOrderTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermAppServiceCertificateOrderTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
