import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAppServiceEnvironmentV3Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_environment_v3#name DataAzurermAppServiceEnvironmentV3#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_environment_v3#resource_group_name DataAzurermAppServiceEnvironmentV3#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_environment_v3#timeouts DataAzurermAppServiceEnvironmentV3#timeouts}
    */
    readonly timeouts?: DataAzurermAppServiceEnvironmentV3Timeouts;
}
export declare class DataAzurermAppServiceEnvironmentV3ClusterSetting extends cdktf.ComplexComputedList {
    get name(): string;
    get value(): string;
}
export declare class DataAzurermAppServiceEnvironmentV3InboundNetworkDependencies extends cdktf.ComplexComputedList {
    get description(): string;
    get ipAddresses(): string[];
    get ports(): string[];
}
export interface DataAzurermAppServiceEnvironmentV3Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_environment_v3#read DataAzurermAppServiceEnvironmentV3#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAppServiceEnvironmentV3TimeoutsToTerraform(struct?: DataAzurermAppServiceEnvironmentV3TimeoutsOutputReference | DataAzurermAppServiceEnvironmentV3Timeouts | cdktf.IResolvable): any;
export declare class DataAzurermAppServiceEnvironmentV3TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermAppServiceEnvironmentV3Timeouts | undefined;
    set internalValue(value: DataAzurermAppServiceEnvironmentV3Timeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_environment_v3 azurerm_app_service_environment_v3}
*/
export declare class DataAzurermAppServiceEnvironmentV3 extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/app_service_environment_v3 azurerm_app_service_environment_v3} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAppServiceEnvironmentV3Config
    */
    constructor(scope: Construct, id: string, config: DataAzurermAppServiceEnvironmentV3Config);
    get allowNewPrivateEndpointConnections(): cdktf.IResolvable;
    clusterSetting(index: string): DataAzurermAppServiceEnvironmentV3ClusterSetting;
    get dedicatedHostCount(): number;
    get dnsSuffix(): string;
    get externalInboundIpAddresses(): string[];
    get id(): string;
    inboundNetworkDependencies(index: string): DataAzurermAppServiceEnvironmentV3InboundNetworkDependencies;
    get internalInboundIpAddresses(): string[];
    get internalLoadBalancingMode(): string;
    get ipSslAddressCount(): number;
    get linuxOutboundIpAddresses(): string[];
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get pricingTier(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get subnetId(): string;
    tags(key: string): string | cdktf.IResolvable;
    get windowsOutboundIpAddresses(): string[];
    get zoneRedundant(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermAppServiceEnvironmentV3TimeoutsOutputReference;
    putTimeouts(value: DataAzurermAppServiceEnvironmentV3Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermAppServiceEnvironmentV3Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
