import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermAttestationProviderConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/attestation_provider#name DataAzurermAttestationProvider#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/attestation_provider#resource_group_name DataAzurermAttestationProvider#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/attestation_provider#timeouts DataAzurermAttestationProvider#timeouts}
    */
    readonly timeouts?: DataAzurermAttestationProviderTimeouts;
}
export interface DataAzurermAttestationProviderTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/attestation_provider#read DataAzurermAttestationProvider#read}
    */
    readonly read?: string;
}
export declare function dataAzurermAttestationProviderTimeoutsToTerraform(struct?: DataAzurermAttestationProviderTimeoutsOutputReference | DataAzurermAttestationProviderTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermAttestationProviderTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermAttestationProviderTimeouts | undefined;
    set internalValue(value: DataAzurermAttestationProviderTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/attestation_provider azurerm_attestation_provider}
*/
export declare class DataAzurermAttestationProvider extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/attestation_provider azurerm_attestation_provider} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermAttestationProviderConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermAttestationProviderConfig);
    get attestationUri(): string;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    get trustModel(): string;
    private _timeouts;
    get timeouts(): DataAzurermAttestationProviderTimeoutsOutputReference;
    putTimeouts(value: DataAzurermAttestationProviderTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermAttestationProviderTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
