import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermCosmosdbRestorableDatabaseAccountsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_restorable_database_accounts#location DataAzurermCosmosdbRestorableDatabaseAccounts#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_restorable_database_accounts#name DataAzurermCosmosdbRestorableDatabaseAccounts#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_restorable_database_accounts#timeouts DataAzurermCosmosdbRestorableDatabaseAccounts#timeouts}
    */
    readonly timeouts?: DataAzurermCosmosdbRestorableDatabaseAccountsTimeouts;
}
export declare class DataAzurermCosmosdbRestorableDatabaseAccountsAccountsRestorableLocations extends cdktf.ComplexComputedList {
    get creationTime(): string;
    get deletionTime(): string;
    get location(): string;
    get regionalDatabaseAccountInstanceId(): string;
}
export declare class DataAzurermCosmosdbRestorableDatabaseAccountsAccounts extends cdktf.ComplexComputedList {
    get apiType(): string;
    get creationTime(): string;
    get deletionTime(): string;
    get id(): string;
    get restorableLocations(): cdktf.IResolvable;
}
export interface DataAzurermCosmosdbRestorableDatabaseAccountsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_restorable_database_accounts#read DataAzurermCosmosdbRestorableDatabaseAccounts#read}
    */
    readonly read?: string;
}
export declare function dataAzurermCosmosdbRestorableDatabaseAccountsTimeoutsToTerraform(struct?: DataAzurermCosmosdbRestorableDatabaseAccountsTimeoutsOutputReference | DataAzurermCosmosdbRestorableDatabaseAccountsTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermCosmosdbRestorableDatabaseAccountsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermCosmosdbRestorableDatabaseAccountsTimeouts | undefined;
    set internalValue(value: DataAzurermCosmosdbRestorableDatabaseAccountsTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_restorable_database_accounts azurerm_cosmosdb_restorable_database_accounts}
*/
export declare class DataAzurermCosmosdbRestorableDatabaseAccounts extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/cosmosdb_restorable_database_accounts azurerm_cosmosdb_restorable_database_accounts} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermCosmosdbRestorableDatabaseAccountsConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermCosmosdbRestorableDatabaseAccountsConfig);
    accounts(index: string): DataAzurermCosmosdbRestorableDatabaseAccountsAccounts;
    get id(): string;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermCosmosdbRestorableDatabaseAccountsTimeoutsOutputReference;
    putTimeouts(value: DataAzurermCosmosdbRestorableDatabaseAccountsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermCosmosdbRestorableDatabaseAccountsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
