import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDataFactoryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_factory#name DataAzurermDataFactory#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_factory#resource_group_name DataAzurermDataFactory#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_factory#timeouts DataAzurermDataFactory#timeouts}
    */
    readonly timeouts?: DataAzurermDataFactoryTimeouts;
}
export declare class DataAzurermDataFactoryGithubConfiguration extends cdktf.ComplexComputedList {
    get accountName(): string;
    get branchName(): string;
    get gitUrl(): string;
    get repositoryName(): string;
    get rootFolder(): string;
}
export declare class DataAzurermDataFactoryIdentity extends cdktf.ComplexComputedList {
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermDataFactoryVstsConfiguration extends cdktf.ComplexComputedList {
    get accountName(): string;
    get branchName(): string;
    get projectName(): string;
    get repositoryName(): string;
    get rootFolder(): string;
    get tenantId(): string;
}
export interface DataAzurermDataFactoryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_factory#read DataAzurermDataFactory#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDataFactoryTimeoutsToTerraform(struct?: DataAzurermDataFactoryTimeoutsOutputReference | DataAzurermDataFactoryTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDataFactoryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermDataFactoryTimeouts | undefined;
    set internalValue(value: DataAzurermDataFactoryTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/data_factory azurerm_data_factory}
*/
export declare class DataAzurermDataFactory extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/data_factory azurerm_data_factory} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDataFactoryConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDataFactoryConfig);
    githubConfiguration(index: string): DataAzurermDataFactoryGithubConfiguration;
    get id(): string;
    identity(index: string): DataAzurermDataFactoryIdentity;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    vstsConfiguration(index: string): DataAzurermDataFactoryVstsConfiguration;
    private _timeouts;
    get timeouts(): DataAzurermDataFactoryTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDataFactoryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermDataFactoryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
