import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDataShareAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_account#name DataAzurermDataShareAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_account#resource_group_name DataAzurermDataShareAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_account#timeouts DataAzurermDataShareAccount#timeouts}
    */
    readonly timeouts?: DataAzurermDataShareAccountTimeouts;
}
export declare class DataAzurermDataShareAccountIdentity extends cdktf.ComplexComputedList {
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export interface DataAzurermDataShareAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_account#read DataAzurermDataShareAccount#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDataShareAccountTimeoutsToTerraform(struct?: DataAzurermDataShareAccountTimeoutsOutputReference | DataAzurermDataShareAccountTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDataShareAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermDataShareAccountTimeouts | undefined;
    set internalValue(value: DataAzurermDataShareAccountTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_account azurerm_data_share_account}
*/
export declare class DataAzurermDataShareAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_account azurerm_data_share_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDataShareAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDataShareAccountConfig);
    get id(): string;
    identity(index: string): DataAzurermDataShareAccountIdentity;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermDataShareAccountTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDataShareAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermDataShareAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
