import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDataShareDatasetDataLakeGen2Config extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_data_lake_gen2#name DataAzurermDataShareDatasetDataLakeGen2#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_data_lake_gen2#share_id DataAzurermDataShareDatasetDataLakeGen2#share_id}
    */
    readonly shareId: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_data_lake_gen2#timeouts DataAzurermDataShareDatasetDataLakeGen2#timeouts}
    */
    readonly timeouts?: DataAzurermDataShareDatasetDataLakeGen2Timeouts;
}
export interface DataAzurermDataShareDatasetDataLakeGen2Timeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_data_lake_gen2#read DataAzurermDataShareDatasetDataLakeGen2#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDataShareDatasetDataLakeGen2TimeoutsToTerraform(struct?: DataAzurermDataShareDatasetDataLakeGen2TimeoutsOutputReference | DataAzurermDataShareDatasetDataLakeGen2Timeouts | cdktf.IResolvable): any;
export declare class DataAzurermDataShareDatasetDataLakeGen2TimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermDataShareDatasetDataLakeGen2Timeouts | undefined;
    set internalValue(value: DataAzurermDataShareDatasetDataLakeGen2Timeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_data_lake_gen2 azurerm_data_share_dataset_data_lake_gen2}
*/
export declare class DataAzurermDataShareDatasetDataLakeGen2 extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_data_lake_gen2 azurerm_data_share_dataset_data_lake_gen2} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDataShareDatasetDataLakeGen2Config
    */
    constructor(scope: Construct, id: string, config: DataAzurermDataShareDatasetDataLakeGen2Config);
    get displayName(): string;
    get filePath(): string;
    get fileSystemName(): string;
    get folderPath(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _shareId?;
    get shareId(): string;
    set shareId(value: string);
    get shareIdInput(): string | undefined;
    get storageAccountId(): string;
    private _timeouts;
    get timeouts(): DataAzurermDataShareDatasetDataLakeGen2TimeoutsOutputReference;
    putTimeouts(value: DataAzurermDataShareDatasetDataLakeGen2Timeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermDataShareDatasetDataLakeGen2Timeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
