import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermDatabaseMigrationProjectConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/database_migration_project#name DataAzurermDatabaseMigrationProject#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/database_migration_project#resource_group_name DataAzurermDatabaseMigrationProject#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/database_migration_project#service_name DataAzurermDatabaseMigrationProject#service_name}
    */
    readonly serviceName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/database_migration_project#timeouts DataAzurermDatabaseMigrationProject#timeouts}
    */
    readonly timeouts?: DataAzurermDatabaseMigrationProjectTimeouts;
}
export interface DataAzurermDatabaseMigrationProjectTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/database_migration_project#read DataAzurermDatabaseMigrationProject#read}
    */
    readonly read?: string;
}
export declare function dataAzurermDatabaseMigrationProjectTimeoutsToTerraform(struct?: DataAzurermDatabaseMigrationProjectTimeoutsOutputReference | DataAzurermDatabaseMigrationProjectTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermDatabaseMigrationProjectTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermDatabaseMigrationProjectTimeouts | undefined;
    set internalValue(value: DataAzurermDatabaseMigrationProjectTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/database_migration_project azurerm_database_migration_project}
*/
export declare class DataAzurermDatabaseMigrationProject extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/database_migration_project azurerm_database_migration_project} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermDatabaseMigrationProjectConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermDatabaseMigrationProjectConfig);
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _serviceName?;
    get serviceName(): string;
    set serviceName(value: string);
    get serviceNameInput(): string | undefined;
    get sourcePlatform(): string;
    tags(key: string): string | cdktf.IResolvable;
    get targetPlatform(): string;
    private _timeouts;
    get timeouts(): DataAzurermDatabaseMigrationProjectTimeoutsOutputReference;
    putTimeouts(value: DataAzurermDatabaseMigrationProjectTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermDatabaseMigrationProjectTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
