import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermEventgridDomainConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain#inbound_ip_rule DataAzurermEventgridDomain#inbound_ip_rule}
    */
    readonly inboundIpRule?: DataAzurermEventgridDomainInboundIpRule[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain#name DataAzurermEventgridDomain#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain#public_network_access_enabled DataAzurermEventgridDomain#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain#resource_group_name DataAzurermEventgridDomain#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain#tags DataAzurermEventgridDomain#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain#timeouts DataAzurermEventgridDomain#timeouts}
    */
    readonly timeouts?: DataAzurermEventgridDomainTimeouts;
}
export interface DataAzurermEventgridDomainInboundIpRule {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain#action DataAzurermEventgridDomain#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain#ip_mask DataAzurermEventgridDomain#ip_mask}
    */
    readonly ipMask?: string;
}
export declare function dataAzurermEventgridDomainInboundIpRuleToTerraform(struct?: DataAzurermEventgridDomainInboundIpRule | cdktf.IResolvable): any;
export declare class DataAzurermEventgridDomainInputMappingDefaultValues extends cdktf.ComplexComputedList {
    get dataVersion(): string;
    get eventType(): string;
    get subject(): string;
}
export declare class DataAzurermEventgridDomainInputMappingFields extends cdktf.ComplexComputedList {
    get dataVersion(): string;
    get eventTime(): string;
    get eventType(): string;
    get id(): string;
    get subject(): string;
    get topic(): string;
}
export interface DataAzurermEventgridDomainTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain#read DataAzurermEventgridDomain#read}
    */
    readonly read?: string;
}
export declare function dataAzurermEventgridDomainTimeoutsToTerraform(struct?: DataAzurermEventgridDomainTimeoutsOutputReference | DataAzurermEventgridDomainTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermEventgridDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermEventgridDomainTimeouts | undefined;
    set internalValue(value: DataAzurermEventgridDomainTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain azurerm_eventgrid_domain}
*/
export declare class DataAzurermEventgridDomain extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain azurerm_eventgrid_domain} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermEventgridDomainConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermEventgridDomainConfig);
    get endpoint(): string;
    get id(): string;
    private _inboundIpRule?;
    get inboundIpRule(): DataAzurermEventgridDomainInboundIpRule[] | cdktf.IResolvable;
    set inboundIpRule(value: DataAzurermEventgridDomainInboundIpRule[] | cdktf.IResolvable);
    resetInboundIpRule(): void;
    get inboundIpRuleInput(): cdktf.IResolvable | DataAzurermEventgridDomainInboundIpRule[] | undefined;
    inputMappingDefaultValues(index: string): DataAzurermEventgridDomainInputMappingDefaultValues;
    inputMappingFields(index: string): DataAzurermEventgridDomainInputMappingFields;
    get inputSchema(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryAccessKey(): string;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    get timeouts(): DataAzurermEventgridDomainTimeoutsOutputReference;
    putTimeouts(value: DataAzurermEventgridDomainTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermEventgridDomainTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
