import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermEventhubNamespaceAuthorizationRuleConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_namespace_authorization_rule#name DataAzurermEventhubNamespaceAuthorizationRule#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_namespace_authorization_rule#namespace_name DataAzurermEventhubNamespaceAuthorizationRule#namespace_name}
    */
    readonly namespaceName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_namespace_authorization_rule#resource_group_name DataAzurermEventhubNamespaceAuthorizationRule#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_namespace_authorization_rule#timeouts DataAzurermEventhubNamespaceAuthorizationRule#timeouts}
    */
    readonly timeouts?: DataAzurermEventhubNamespaceAuthorizationRuleTimeouts;
}
export interface DataAzurermEventhubNamespaceAuthorizationRuleTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_namespace_authorization_rule#read DataAzurermEventhubNamespaceAuthorizationRule#read}
    */
    readonly read?: string;
}
export declare function dataAzurermEventhubNamespaceAuthorizationRuleTimeoutsToTerraform(struct?: DataAzurermEventhubNamespaceAuthorizationRuleTimeoutsOutputReference | DataAzurermEventhubNamespaceAuthorizationRuleTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermEventhubNamespaceAuthorizationRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermEventhubNamespaceAuthorizationRuleTimeouts | undefined;
    set internalValue(value: DataAzurermEventhubNamespaceAuthorizationRuleTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_namespace_authorization_rule azurerm_eventhub_namespace_authorization_rule}
*/
export declare class DataAzurermEventhubNamespaceAuthorizationRule extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_namespace_authorization_rule azurerm_eventhub_namespace_authorization_rule} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermEventhubNamespaceAuthorizationRuleConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermEventhubNamespaceAuthorizationRuleConfig);
    get id(): string;
    get listen(): cdktf.IResolvable;
    get manage(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _namespaceName?;
    get namespaceName(): string;
    set namespaceName(value: string);
    get namespaceNameInput(): string | undefined;
    get primaryConnectionString(): string;
    get primaryConnectionStringAlias(): string;
    get primaryKey(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryConnectionString(): string;
    get secondaryConnectionStringAlias(): string;
    get secondaryKey(): string;
    get send(): cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermEventhubNamespaceAuthorizationRuleTimeoutsOutputReference;
    putTimeouts(value: DataAzurermEventhubNamespaceAuthorizationRuleTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermEventhubNamespaceAuthorizationRuleTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
