import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermExpressRouteCircuitConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/express_route_circuit#name DataAzurermExpressRouteCircuit#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/express_route_circuit#resource_group_name DataAzurermExpressRouteCircuit#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/express_route_circuit#timeouts DataAzurermExpressRouteCircuit#timeouts}
    */
    readonly timeouts?: DataAzurermExpressRouteCircuitTimeouts;
}
export declare class DataAzurermExpressRouteCircuitPeerings extends cdktf.ComplexComputedList {
    get azureAsn(): number;
    get peerAsn(): number;
    get peeringType(): string;
    get primaryPeerAddressPrefix(): string;
    get secondaryPeerAddressPrefix(): string;
    get sharedKey(): string;
    get vlanId(): number;
}
export declare class DataAzurermExpressRouteCircuitServiceProviderProperties extends cdktf.ComplexComputedList {
    get bandwidthInMbps(): number;
    get peeringLocation(): string;
    get serviceProviderName(): string;
}
export declare class DataAzurermExpressRouteCircuitSku extends cdktf.ComplexComputedList {
    get family(): string;
    get tier(): string;
}
export interface DataAzurermExpressRouteCircuitTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/express_route_circuit#read DataAzurermExpressRouteCircuit#read}
    */
    readonly read?: string;
}
export declare function dataAzurermExpressRouteCircuitTimeoutsToTerraform(struct?: DataAzurermExpressRouteCircuitTimeoutsOutputReference | DataAzurermExpressRouteCircuitTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermExpressRouteCircuitTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermExpressRouteCircuitTimeouts | undefined;
    set internalValue(value: DataAzurermExpressRouteCircuitTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/express_route_circuit azurerm_express_route_circuit}
*/
export declare class DataAzurermExpressRouteCircuit extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/express_route_circuit azurerm_express_route_circuit} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermExpressRouteCircuitConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermExpressRouteCircuitConfig);
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    peerings(index: string): DataAzurermExpressRouteCircuitPeerings;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get serviceKey(): string;
    serviceProviderProperties(index: string): DataAzurermExpressRouteCircuitServiceProviderProperties;
    get serviceProviderProvisioningState(): string;
    sku(index: string): DataAzurermExpressRouteCircuitSku;
    private _timeouts;
    get timeouts(): DataAzurermExpressRouteCircuitTimeoutsOutputReference;
    putTimeouts(value: DataAzurermExpressRouteCircuitTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermExpressRouteCircuitTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
