import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermFirewallPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/firewall_policy#name DataAzurermFirewallPolicy#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/firewall_policy#resource_group_name DataAzurermFirewallPolicy#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/firewall_policy#timeouts DataAzurermFirewallPolicy#timeouts}
    */
    readonly timeouts?: DataAzurermFirewallPolicyTimeouts;
}
export declare class DataAzurermFirewallPolicyDns extends cdktf.ComplexComputedList {
    get networkRuleFqdnEnabled(): cdktf.IResolvable;
    get proxyEnabled(): cdktf.IResolvable;
    get servers(): string[];
}
export declare class DataAzurermFirewallPolicyThreatIntelligenceAllowlist extends cdktf.ComplexComputedList {
    get fqdns(): string[];
    get ipAddresses(): string[];
}
export interface DataAzurermFirewallPolicyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/firewall_policy#read DataAzurermFirewallPolicy#read}
    */
    readonly read?: string;
}
export declare function dataAzurermFirewallPolicyTimeoutsToTerraform(struct?: DataAzurermFirewallPolicyTimeoutsOutputReference | DataAzurermFirewallPolicyTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermFirewallPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermFirewallPolicyTimeouts | undefined;
    set internalValue(value: DataAzurermFirewallPolicyTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/firewall_policy azurerm_firewall_policy}
*/
export declare class DataAzurermFirewallPolicy extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/firewall_policy azurerm_firewall_policy} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermFirewallPolicyConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermFirewallPolicyConfig);
    get basePolicyId(): string;
    get childPolicies(): string[];
    dns(index: string): DataAzurermFirewallPolicyDns;
    get firewalls(): string[];
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get ruleCollectionGroups(): string[];
    tags(key: string): string | cdktf.IResolvable;
    threatIntelligenceAllowlist(index: string): DataAzurermFirewallPolicyThreatIntelligenceAllowlist;
    get threatIntelligenceMode(): string;
    private _timeouts;
    get timeouts(): DataAzurermFirewallPolicyTimeoutsOutputReference;
    putTimeouts(value: DataAzurermFirewallPolicyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermFirewallPolicyTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
