import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKubernetesClusterNodePoolConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster_node_pool#kubernetes_cluster_name DataAzurermKubernetesClusterNodePool#kubernetes_cluster_name}
    */
    readonly kubernetesClusterName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster_node_pool#name DataAzurermKubernetesClusterNodePool#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster_node_pool#resource_group_name DataAzurermKubernetesClusterNodePool#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster_node_pool#timeouts DataAzurermKubernetesClusterNodePool#timeouts}
    */
    readonly timeouts?: DataAzurermKubernetesClusterNodePoolTimeouts;
}
export declare class DataAzurermKubernetesClusterNodePoolUpgradeSettings extends cdktf.ComplexComputedList {
    get maxSurge(): string;
}
export interface DataAzurermKubernetesClusterNodePoolTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster_node_pool#read DataAzurermKubernetesClusterNodePool#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKubernetesClusterNodePoolTimeoutsToTerraform(struct?: DataAzurermKubernetesClusterNodePoolTimeoutsOutputReference | DataAzurermKubernetesClusterNodePoolTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKubernetesClusterNodePoolTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermKubernetesClusterNodePoolTimeouts | undefined;
    set internalValue(value: DataAzurermKubernetesClusterNodePoolTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster_node_pool azurerm_kubernetes_cluster_node_pool}
*/
export declare class DataAzurermKubernetesClusterNodePool extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/kubernetes_cluster_node_pool azurerm_kubernetes_cluster_node_pool} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKubernetesClusterNodePoolConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKubernetesClusterNodePoolConfig);
    get availabilityZones(): string[];
    get enableAutoScaling(): cdktf.IResolvable;
    get enableNodePublicIp(): cdktf.IResolvable;
    get evictionPolicy(): string;
    get id(): string;
    private _kubernetesClusterName?;
    get kubernetesClusterName(): string;
    set kubernetesClusterName(value: string);
    get kubernetesClusterNameInput(): string | undefined;
    get maxCount(): number;
    get maxPods(): number;
    get minCount(): number;
    get mode(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get nodeCount(): number;
    nodeLabels(key: string): string | cdktf.IResolvable;
    get nodePublicIpPrefixId(): string;
    get nodeTaints(): string[];
    get orchestratorVersion(): string;
    get osDiskSizeGb(): number;
    get osDiskType(): string;
    get osType(): string;
    get priority(): string;
    get proximityPlacementGroupId(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get spotMaxPrice(): number;
    tags(key: string): string | cdktf.IResolvable;
    upgradeSettings(index: string): DataAzurermKubernetesClusterNodePoolUpgradeSettings;
    get vmSize(): string;
    get vnetSubnetId(): string;
    get zones(): string[];
    private _timeouts;
    get timeouts(): DataAzurermKubernetesClusterNodePoolTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKubernetesClusterNodePoolTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermKubernetesClusterNodePoolTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
