import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermKustoClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kusto_cluster#name DataAzurermKustoCluster#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kusto_cluster#resource_group_name DataAzurermKustoCluster#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kusto_cluster#timeouts DataAzurermKustoCluster#timeouts}
    */
    readonly timeouts?: DataAzurermKustoClusterTimeouts;
}
export interface DataAzurermKustoClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/kusto_cluster#read DataAzurermKustoCluster#read}
    */
    readonly read?: string;
}
export declare function dataAzurermKustoClusterTimeoutsToTerraform(struct?: DataAzurermKustoClusterTimeoutsOutputReference | DataAzurermKustoClusterTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermKustoClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermKustoClusterTimeouts | undefined;
    set internalValue(value: DataAzurermKustoClusterTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/kusto_cluster azurerm_kusto_cluster}
*/
export declare class DataAzurermKustoCluster extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/kusto_cluster azurerm_kusto_cluster} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermKustoClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermKustoClusterConfig);
    get dataIngestionUri(): string;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    get uri(): string;
    private _timeouts;
    get timeouts(): DataAzurermKustoClusterTimeoutsOutputReference;
    putTimeouts(value: DataAzurermKustoClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermKustoClusterTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
