import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermLbConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb#name DataAzurermLb#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb#resource_group_name DataAzurermLb#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb#timeouts DataAzurermLb#timeouts}
    */
    readonly timeouts?: DataAzurermLbTimeouts;
}
export declare class DataAzurermLbFrontendIpConfiguration extends cdktf.ComplexComputedList {
    get id(): string;
    get name(): string;
    get privateIpAddress(): string;
    get privateIpAddressAllocation(): string;
    get privateIpAddressVersion(): string;
    get publicIpAddressId(): string;
    get subnetId(): string;
    get zones(): string[];
}
export interface DataAzurermLbTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb#read DataAzurermLb#read}
    */
    readonly read?: string;
}
export declare function dataAzurermLbTimeoutsToTerraform(struct?: DataAzurermLbTimeoutsOutputReference | DataAzurermLbTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermLbTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermLbTimeouts | undefined;
    set internalValue(value: DataAzurermLbTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/lb azurerm_lb}
*/
export declare class DataAzurermLb extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/lb azurerm_lb} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermLbConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermLbConfig);
    frontendIpConfiguration(index: string): DataAzurermLbFrontendIpConfiguration;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get privateIpAddress(): string;
    get privateIpAddresses(): string[];
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sku(): string;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermLbTimeoutsOutputReference;
    putTimeouts(value: DataAzurermLbTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermLbTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
