import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermLocalNetworkGatewayConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/local_network_gateway#name DataAzurermLocalNetworkGateway#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/local_network_gateway#resource_group_name DataAzurermLocalNetworkGateway#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/local_network_gateway#timeouts DataAzurermLocalNetworkGateway#timeouts}
    */
    readonly timeouts?: DataAzurermLocalNetworkGatewayTimeouts;
}
export declare class DataAzurermLocalNetworkGatewayBgpSettings extends cdktf.ComplexComputedList {
    get asn(): number;
    get bgpPeeringAddress(): string;
    get peerWeight(): number;
}
export interface DataAzurermLocalNetworkGatewayTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/local_network_gateway#read DataAzurermLocalNetworkGateway#read}
    */
    readonly read?: string;
}
export declare function dataAzurermLocalNetworkGatewayTimeoutsToTerraform(struct?: DataAzurermLocalNetworkGatewayTimeoutsOutputReference | DataAzurermLocalNetworkGatewayTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermLocalNetworkGatewayTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermLocalNetworkGatewayTimeouts | undefined;
    set internalValue(value: DataAzurermLocalNetworkGatewayTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/local_network_gateway azurerm_local_network_gateway}
*/
export declare class DataAzurermLocalNetworkGateway extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/local_network_gateway azurerm_local_network_gateway} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermLocalNetworkGatewayConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermLocalNetworkGatewayConfig);
    get addressSpace(): string[];
    bgpSettings(index: string): DataAzurermLocalNetworkGatewayBgpSettings;
    get gatewayAddress(): string;
    get gatewayFqdn(): string;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermLocalNetworkGatewayTimeoutsOutputReference;
    putTimeouts(value: DataAzurermLocalNetworkGatewayTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermLocalNetworkGatewayTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
