import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermLogAnalyticsWorkspaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/log_analytics_workspace#name DataAzurermLogAnalyticsWorkspace#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/log_analytics_workspace#resource_group_name DataAzurermLogAnalyticsWorkspace#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/log_analytics_workspace#timeouts DataAzurermLogAnalyticsWorkspace#timeouts}
    */
    readonly timeouts?: DataAzurermLogAnalyticsWorkspaceTimeouts;
}
export interface DataAzurermLogAnalyticsWorkspaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/log_analytics_workspace#read DataAzurermLogAnalyticsWorkspace#read}
    */
    readonly read?: string;
}
export declare function dataAzurermLogAnalyticsWorkspaceTimeoutsToTerraform(struct?: DataAzurermLogAnalyticsWorkspaceTimeoutsOutputReference | DataAzurermLogAnalyticsWorkspaceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermLogAnalyticsWorkspaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermLogAnalyticsWorkspaceTimeouts | undefined;
    set internalValue(value: DataAzurermLogAnalyticsWorkspaceTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/log_analytics_workspace azurerm_log_analytics_workspace}
*/
export declare class DataAzurermLogAnalyticsWorkspace extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/log_analytics_workspace azurerm_log_analytics_workspace} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermLogAnalyticsWorkspaceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermLogAnalyticsWorkspaceConfig);
    get dailyQuotaGb(): number;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get portalUrl(): string;
    get primarySharedKey(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get retentionInDays(): number;
    get secondarySharedKey(): string;
    get sku(): string;
    tags(key: string): string | cdktf.IResolvable;
    get workspaceId(): string;
    private _timeouts;
    get timeouts(): DataAzurermLogAnalyticsWorkspaceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermLogAnalyticsWorkspaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermLogAnalyticsWorkspaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
