import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermLogicAppStandardConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#name DataAzurermLogicAppStandard#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#resource_group_name DataAzurermLogicAppStandard#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#tags DataAzurermLogicAppStandard#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * site_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#site_config DataAzurermLogicAppStandard#site_config}
    */
    readonly siteConfig?: DataAzurermLogicAppStandardSiteConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#timeouts DataAzurermLogicAppStandard#timeouts}
    */
    readonly timeouts?: DataAzurermLogicAppStandardTimeouts;
}
export declare class DataAzurermLogicAppStandardConnectionString extends cdktf.ComplexComputedList {
    get name(): string;
    get type(): string;
    get value(): string;
}
export declare class DataAzurermLogicAppStandardIdentity extends cdktf.ComplexComputedList {
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export declare class DataAzurermLogicAppStandardSiteCredential extends cdktf.ComplexComputedList {
    get password(): string;
    get username(): string;
}
export interface DataAzurermLogicAppStandardSiteConfigIpRestrictionHeaders {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#x_azure_fdid DataAzurermLogicAppStandard#x_azure_fdid}
    */
    readonly xAzureFdid?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#x_fd_health_probe DataAzurermLogicAppStandard#x_fd_health_probe}
    */
    readonly xFdHealthProbe?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#x_forwarded_for DataAzurermLogicAppStandard#x_forwarded_for}
    */
    readonly xForwardedFor?: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#x_forwarded_host DataAzurermLogicAppStandard#x_forwarded_host}
    */
    readonly xForwardedHost?: string[];
}
export declare function dataAzurermLogicAppStandardSiteConfigIpRestrictionHeadersToTerraform(struct?: DataAzurermLogicAppStandardSiteConfigIpRestrictionHeaders | cdktf.IResolvable): any;
export interface DataAzurermLogicAppStandardSiteConfigIpRestriction {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#action DataAzurermLogicAppStandard#action}
    */
    readonly action?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#headers DataAzurermLogicAppStandard#headers}
    */
    readonly headers?: DataAzurermLogicAppStandardSiteConfigIpRestrictionHeaders[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#ip_address DataAzurermLogicAppStandard#ip_address}
    */
    readonly ipAddress?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#name DataAzurermLogicAppStandard#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#priority DataAzurermLogicAppStandard#priority}
    */
    readonly priority?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#service_tag DataAzurermLogicAppStandard#service_tag}
    */
    readonly serviceTag?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#virtual_network_subnet_id DataAzurermLogicAppStandard#virtual_network_subnet_id}
    */
    readonly virtualNetworkSubnetId?: string;
}
export declare function dataAzurermLogicAppStandardSiteConfigIpRestrictionToTerraform(struct?: DataAzurermLogicAppStandardSiteConfigIpRestriction | cdktf.IResolvable): any;
export interface DataAzurermLogicAppStandardSiteConfigCors {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#allowed_origins DataAzurermLogicAppStandard#allowed_origins}
    */
    readonly allowedOrigins: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#support_credentials DataAzurermLogicAppStandard#support_credentials}
    */
    readonly supportCredentials?: boolean | cdktf.IResolvable;
}
export declare function dataAzurermLogicAppStandardSiteConfigCorsToTerraform(struct?: DataAzurermLogicAppStandardSiteConfigCorsOutputReference | DataAzurermLogicAppStandardSiteConfigCors): any;
export declare class DataAzurermLogicAppStandardSiteConfigCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermLogicAppStandardSiteConfigCors | undefined;
    set internalValue(value: DataAzurermLogicAppStandardSiteConfigCors | undefined);
    private _allowedOrigins?;
    get allowedOrigins(): string[];
    set allowedOrigins(value: string[]);
    get allowedOriginsInput(): string[] | undefined;
    private _supportCredentials?;
    get supportCredentials(): boolean | cdktf.IResolvable;
    set supportCredentials(value: boolean | cdktf.IResolvable);
    resetSupportCredentials(): void;
    get supportCredentialsInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DataAzurermLogicAppStandardSiteConfig {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#always_on DataAzurermLogicAppStandard#always_on}
    */
    readonly alwaysOn?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#app_scale_limit DataAzurermLogicAppStandard#app_scale_limit}
    */
    readonly appScaleLimit?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#dotnet_framework_version DataAzurermLogicAppStandard#dotnet_framework_version}
    */
    readonly dotnetFrameworkVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#elastic_instance_minimum DataAzurermLogicAppStandard#elastic_instance_minimum}
    */
    readonly elasticInstanceMinimum?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#ftps_state DataAzurermLogicAppStandard#ftps_state}
    */
    readonly ftpsState?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#health_check_path DataAzurermLogicAppStandard#health_check_path}
    */
    readonly healthCheckPath?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#http2_enabled DataAzurermLogicAppStandard#http2_enabled}
    */
    readonly http2Enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#ip_restriction DataAzurermLogicAppStandard#ip_restriction}
    */
    readonly ipRestriction?: DataAzurermLogicAppStandardSiteConfigIpRestriction[] | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#linux_fx_version DataAzurermLogicAppStandard#linux_fx_version}
    */
    readonly linuxFxVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#min_tls_version DataAzurermLogicAppStandard#min_tls_version}
    */
    readonly minTlsVersion?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#pre_warmed_instance_count DataAzurermLogicAppStandard#pre_warmed_instance_count}
    */
    readonly preWarmedInstanceCount?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#runtime_scale_monitoring_enabled DataAzurermLogicAppStandard#runtime_scale_monitoring_enabled}
    */
    readonly runtimeScaleMonitoringEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#use_32_bit_worker_process DataAzurermLogicAppStandard#use_32_bit_worker_process}
    */
    readonly use32BitWorkerProcess?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#vnet_route_all_enabled DataAzurermLogicAppStandard#vnet_route_all_enabled}
    */
    readonly vnetRouteAllEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#websockets_enabled DataAzurermLogicAppStandard#websockets_enabled}
    */
    readonly websocketsEnabled?: boolean | cdktf.IResolvable;
    /**
    * cors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#cors DataAzurermLogicAppStandard#cors}
    */
    readonly cors?: DataAzurermLogicAppStandardSiteConfigCors;
}
export declare function dataAzurermLogicAppStandardSiteConfigToTerraform(struct?: DataAzurermLogicAppStandardSiteConfigOutputReference | DataAzurermLogicAppStandardSiteConfig): any;
export declare class DataAzurermLogicAppStandardSiteConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermLogicAppStandardSiteConfig | undefined;
    set internalValue(value: DataAzurermLogicAppStandardSiteConfig | undefined);
    private _alwaysOn?;
    get alwaysOn(): boolean | cdktf.IResolvable;
    set alwaysOn(value: boolean | cdktf.IResolvable);
    resetAlwaysOn(): void;
    get alwaysOnInput(): boolean | cdktf.IResolvable | undefined;
    private _appScaleLimit?;
    get appScaleLimit(): number;
    set appScaleLimit(value: number);
    resetAppScaleLimit(): void;
    get appScaleLimitInput(): number | undefined;
    private _dotnetFrameworkVersion?;
    get dotnetFrameworkVersion(): string;
    set dotnetFrameworkVersion(value: string);
    resetDotnetFrameworkVersion(): void;
    get dotnetFrameworkVersionInput(): string | undefined;
    private _elasticInstanceMinimum?;
    get elasticInstanceMinimum(): number;
    set elasticInstanceMinimum(value: number);
    resetElasticInstanceMinimum(): void;
    get elasticInstanceMinimumInput(): number | undefined;
    private _ftpsState?;
    get ftpsState(): string;
    set ftpsState(value: string);
    resetFtpsState(): void;
    get ftpsStateInput(): string | undefined;
    private _healthCheckPath?;
    get healthCheckPath(): string;
    set healthCheckPath(value: string);
    resetHealthCheckPath(): void;
    get healthCheckPathInput(): string | undefined;
    private _http2Enabled?;
    get http2Enabled(): boolean | cdktf.IResolvable;
    set http2Enabled(value: boolean | cdktf.IResolvable);
    resetHttp2Enabled(): void;
    get http2EnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _ipRestriction?;
    get ipRestriction(): DataAzurermLogicAppStandardSiteConfigIpRestriction[] | cdktf.IResolvable;
    set ipRestriction(value: DataAzurermLogicAppStandardSiteConfigIpRestriction[] | cdktf.IResolvable);
    resetIpRestriction(): void;
    get ipRestrictionInput(): cdktf.IResolvable | DataAzurermLogicAppStandardSiteConfigIpRestriction[] | undefined;
    private _linuxFxVersion?;
    get linuxFxVersion(): string;
    set linuxFxVersion(value: string);
    resetLinuxFxVersion(): void;
    get linuxFxVersionInput(): string | undefined;
    private _minTlsVersion?;
    get minTlsVersion(): string;
    set minTlsVersion(value: string);
    resetMinTlsVersion(): void;
    get minTlsVersionInput(): string | undefined;
    private _preWarmedInstanceCount?;
    get preWarmedInstanceCount(): number;
    set preWarmedInstanceCount(value: number);
    resetPreWarmedInstanceCount(): void;
    get preWarmedInstanceCountInput(): number | undefined;
    private _runtimeScaleMonitoringEnabled?;
    get runtimeScaleMonitoringEnabled(): boolean | cdktf.IResolvable;
    set runtimeScaleMonitoringEnabled(value: boolean | cdktf.IResolvable);
    resetRuntimeScaleMonitoringEnabled(): void;
    get runtimeScaleMonitoringEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _use32BitWorkerProcess?;
    get use32BitWorkerProcess(): boolean | cdktf.IResolvable;
    set use32BitWorkerProcess(value: boolean | cdktf.IResolvable);
    resetUse32BitWorkerProcess(): void;
    get use32BitWorkerProcessInput(): boolean | cdktf.IResolvable | undefined;
    private _vnetRouteAllEnabled?;
    get vnetRouteAllEnabled(): boolean | cdktf.IResolvable;
    set vnetRouteAllEnabled(value: boolean | cdktf.IResolvable);
    resetVnetRouteAllEnabled(): void;
    get vnetRouteAllEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _websocketsEnabled?;
    get websocketsEnabled(): boolean | cdktf.IResolvable;
    set websocketsEnabled(value: boolean | cdktf.IResolvable);
    resetWebsocketsEnabled(): void;
    get websocketsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _cors;
    get cors(): DataAzurermLogicAppStandardSiteConfigCorsOutputReference;
    putCors(value: DataAzurermLogicAppStandardSiteConfigCors): void;
    resetCors(): void;
    get corsInput(): DataAzurermLogicAppStandardSiteConfigCors | undefined;
}
export interface DataAzurermLogicAppStandardTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard#read DataAzurermLogicAppStandard#read}
    */
    readonly read?: string;
}
export declare function dataAzurermLogicAppStandardTimeoutsToTerraform(struct?: DataAzurermLogicAppStandardTimeoutsOutputReference | DataAzurermLogicAppStandardTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermLogicAppStandardTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermLogicAppStandardTimeouts | undefined;
    set internalValue(value: DataAzurermLogicAppStandardTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard azurerm_logic_app_standard}
*/
export declare class DataAzurermLogicAppStandard extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_standard azurerm_logic_app_standard} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermLogicAppStandardConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermLogicAppStandardConfig);
    get appServicePlanId(): string;
    appSettings(key: string): string | cdktf.IResolvable;
    get bundleVersion(): string;
    get clientAffinityEnabled(): cdktf.IResolvable;
    get clientCertificateMode(): string;
    connectionString(index: string): DataAzurermLogicAppStandardConnectionString;
    get customDomainVerificationId(): string;
    get defaultHostname(): string;
    get enabled(): cdktf.IResolvable;
    get httpsOnly(): cdktf.IResolvable;
    get id(): string;
    identity(index: string): DataAzurermLogicAppStandardIdentity;
    get kind(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get outboundIpAddresses(): string;
    get possibleOutboundIpAddresses(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    siteCredential(index: string): DataAzurermLogicAppStandardSiteCredential;
    get storageAccountAccessKey(): string;
    get storageAccountName(): string;
    get storageAccountShareName(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get useExtensionBundle(): cdktf.IResolvable;
    get version(): string;
    private _siteConfig;
    get siteConfig(): DataAzurermLogicAppStandardSiteConfigOutputReference;
    putSiteConfig(value: DataAzurermLogicAppStandardSiteConfig): void;
    resetSiteConfig(): void;
    get siteConfigInput(): DataAzurermLogicAppStandardSiteConfig | undefined;
    private _timeouts;
    get timeouts(): DataAzurermLogicAppStandardTimeoutsOutputReference;
    putTimeouts(value: DataAzurermLogicAppStandardTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermLogicAppStandardTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
