import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermLogicAppWorkflowConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_workflow#name DataAzurermLogicAppWorkflow#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_workflow#resource_group_name DataAzurermLogicAppWorkflow#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_workflow#timeouts DataAzurermLogicAppWorkflow#timeouts}
    */
    readonly timeouts?: DataAzurermLogicAppWorkflowTimeouts;
}
export declare class DataAzurermLogicAppWorkflowIdentity extends cdktf.ComplexComputedList {
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export interface DataAzurermLogicAppWorkflowTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_workflow#read DataAzurermLogicAppWorkflow#read}
    */
    readonly read?: string;
}
export declare function dataAzurermLogicAppWorkflowTimeoutsToTerraform(struct?: DataAzurermLogicAppWorkflowTimeoutsOutputReference | DataAzurermLogicAppWorkflowTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermLogicAppWorkflowTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermLogicAppWorkflowTimeouts | undefined;
    set internalValue(value: DataAzurermLogicAppWorkflowTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_workflow azurerm_logic_app_workflow}
*/
export declare class DataAzurermLogicAppWorkflow extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/logic_app_workflow azurerm_logic_app_workflow} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermLogicAppWorkflowConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermLogicAppWorkflowConfig);
    get accessEndpoint(): string;
    get connectorEndpointIpAddresses(): string[];
    get connectorOutboundIpAddresses(): string[];
    get id(): string;
    identity(index: string): DataAzurermLogicAppWorkflowIdentity;
    get location(): string;
    get logicAppIntegrationAccountId(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    parameters(key: string): string | cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    get workflowEndpointIpAddresses(): string[];
    get workflowOutboundIpAddresses(): string[];
    get workflowSchema(): string;
    get workflowVersion(): string;
    private _timeouts;
    get timeouts(): DataAzurermLogicAppWorkflowTimeoutsOutputReference;
    putTimeouts(value: DataAzurermLogicAppWorkflowTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermLogicAppWorkflowTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
