import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMachineLearningWorkspaceConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/machine_learning_workspace#name DataAzurermMachineLearningWorkspace#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/machine_learning_workspace#resource_group_name DataAzurermMachineLearningWorkspace#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/machine_learning_workspace#timeouts DataAzurermMachineLearningWorkspace#timeouts}
    */
    readonly timeouts?: DataAzurermMachineLearningWorkspaceTimeouts;
}
export declare class DataAzurermMachineLearningWorkspaceIdentity extends cdktf.ComplexComputedList {
    get identityIds(): string[];
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
}
export interface DataAzurermMachineLearningWorkspaceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/machine_learning_workspace#read DataAzurermMachineLearningWorkspace#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMachineLearningWorkspaceTimeoutsToTerraform(struct?: DataAzurermMachineLearningWorkspaceTimeoutsOutputReference | DataAzurermMachineLearningWorkspaceTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMachineLearningWorkspaceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermMachineLearningWorkspaceTimeouts | undefined;
    set internalValue(value: DataAzurermMachineLearningWorkspaceTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/machine_learning_workspace azurerm_machine_learning_workspace}
*/
export declare class DataAzurermMachineLearningWorkspace extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/machine_learning_workspace azurerm_machine_learning_workspace} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMachineLearningWorkspaceConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMachineLearningWorkspaceConfig);
    get id(): string;
    identity(index: string): DataAzurermMachineLearningWorkspaceIdentity;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermMachineLearningWorkspaceTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMachineLearningWorkspaceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermMachineLearningWorkspaceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
