import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMaintenanceConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/maintenance_configuration#name DataAzurermMaintenanceConfiguration#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/maintenance_configuration#resource_group_name DataAzurermMaintenanceConfiguration#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/maintenance_configuration#timeouts DataAzurermMaintenanceConfiguration#timeouts}
    */
    readonly timeouts?: DataAzurermMaintenanceConfigurationTimeouts;
}
export declare class DataAzurermMaintenanceConfigurationWindow extends cdktf.ComplexComputedList {
    get duration(): string;
    get expirationDateTime(): string;
    get recurEvery(): string;
    get startDateTime(): string;
    get timeZone(): string;
}
export interface DataAzurermMaintenanceConfigurationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/maintenance_configuration#read DataAzurermMaintenanceConfiguration#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMaintenanceConfigurationTimeoutsToTerraform(struct?: DataAzurermMaintenanceConfigurationTimeoutsOutputReference | DataAzurermMaintenanceConfigurationTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMaintenanceConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermMaintenanceConfigurationTimeouts | undefined;
    set internalValue(value: DataAzurermMaintenanceConfigurationTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/maintenance_configuration azurerm_maintenance_configuration}
*/
export declare class DataAzurermMaintenanceConfiguration extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/maintenance_configuration azurerm_maintenance_configuration} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMaintenanceConfigurationConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMaintenanceConfigurationConfig);
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    properties(key: string): string | cdktf.IResolvable;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get scope(): string;
    tags(key: string): string | cdktf.IResolvable;
    get visibility(): string;
    window(index: string): DataAzurermMaintenanceConfigurationWindow;
    private _timeouts;
    get timeouts(): DataAzurermMaintenanceConfigurationTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMaintenanceConfigurationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermMaintenanceConfigurationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
