import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermManagedDiskConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/managed_disk#name DataAzurermManagedDisk#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/managed_disk#resource_group_name DataAzurermManagedDisk#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/managed_disk#timeouts DataAzurermManagedDisk#timeouts}
    */
    readonly timeouts?: DataAzurermManagedDiskTimeouts;
}
export interface DataAzurermManagedDiskTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/managed_disk#read DataAzurermManagedDisk#read}
    */
    readonly read?: string;
}
export declare function dataAzurermManagedDiskTimeoutsToTerraform(struct?: DataAzurermManagedDiskTimeoutsOutputReference | DataAzurermManagedDiskTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermManagedDiskTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermManagedDiskTimeouts | undefined;
    set internalValue(value: DataAzurermManagedDiskTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/managed_disk azurerm_managed_disk}
*/
export declare class DataAzurermManagedDisk extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/managed_disk azurerm_managed_disk} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermManagedDiskConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermManagedDiskConfig);
    get createOption(): string;
    get diskEncryptionSetId(): string;
    get diskIopsReadWrite(): number;
    get diskMbpsReadWrite(): number;
    get diskSizeGb(): number;
    get id(): string;
    get imageReferenceId(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get osType(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get sourceResourceId(): string;
    get sourceUri(): string;
    get storageAccountId(): string;
    get storageAccountType(): string;
    tags(key: string): string | cdktf.IResolvable;
    get zones(): string[];
    private _timeouts;
    get timeouts(): DataAzurermManagedDiskTimeoutsOutputReference;
    putTimeouts(value: DataAzurermManagedDiskTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermManagedDiskTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
