import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMapsAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/maps_account#name DataAzurermMapsAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/maps_account#resource_group_name DataAzurermMapsAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/maps_account#tags DataAzurermMapsAccount#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/maps_account#timeouts DataAzurermMapsAccount#timeouts}
    */
    readonly timeouts?: DataAzurermMapsAccountTimeouts;
}
export interface DataAzurermMapsAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/maps_account#read DataAzurermMapsAccount#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMapsAccountTimeoutsToTerraform(struct?: DataAzurermMapsAccountTimeoutsOutputReference | DataAzurermMapsAccountTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMapsAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermMapsAccountTimeouts | undefined;
    set internalValue(value: DataAzurermMapsAccountTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/maps_account azurerm_maps_account}
*/
export declare class DataAzurermMapsAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/maps_account azurerm_maps_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMapsAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMapsAccountConfig);
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryAccessKey(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    get skuName(): string;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    get xMsClientId(): string;
    private _timeouts;
    get timeouts(): DataAzurermMapsAccountTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMapsAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermMapsAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
