import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMariadbServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mariadb_server#name DataAzurermMariadbServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mariadb_server#resource_group_name DataAzurermMariadbServer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mariadb_server#timeouts DataAzurermMariadbServer#timeouts}
    */
    readonly timeouts?: DataAzurermMariadbServerTimeouts;
}
export declare class DataAzurermMariadbServerStorageProfile extends cdktf.ComplexComputedList {
    get autoGrow(): string;
    get backupRetentionDays(): number;
    get geoRedundantBackup(): string;
    get storageMb(): number;
}
export interface DataAzurermMariadbServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mariadb_server#read DataAzurermMariadbServer#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMariadbServerTimeoutsToTerraform(struct?: DataAzurermMariadbServerTimeoutsOutputReference | DataAzurermMariadbServerTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMariadbServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermMariadbServerTimeouts | undefined;
    set internalValue(value: DataAzurermMariadbServerTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/mariadb_server azurerm_mariadb_server}
*/
export declare class DataAzurermMariadbServer extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/mariadb_server azurerm_mariadb_server} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMariadbServerConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMariadbServerConfig);
    get administratorLogin(): string;
    get fqdn(): string;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get skuName(): string;
    get sslEnforcement(): string;
    storageProfile(index: string): DataAzurermMariadbServerStorageProfile;
    tags(key: string): string | cdktf.IResolvable;
    get version(): string;
    private _timeouts;
    get timeouts(): DataAzurermMariadbServerTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMariadbServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermMariadbServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
