import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMonitorActionGroupConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_action_group#name DataAzurermMonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_action_group#resource_group_name DataAzurermMonitorActionGroup#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * event_hub_receiver block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_action_group#event_hub_receiver DataAzurermMonitorActionGroup#event_hub_receiver}
    */
    readonly eventHubReceiver?: DataAzurermMonitorActionGroupEventHubReceiver[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_action_group#timeouts DataAzurermMonitorActionGroup#timeouts}
    */
    readonly timeouts?: DataAzurermMonitorActionGroupTimeouts;
}
export declare class DataAzurermMonitorActionGroupArmRoleReceiver extends cdktf.ComplexComputedList {
    get name(): string;
    get roleId(): string;
    get useCommonAlertSchema(): cdktf.IResolvable;
}
export declare class DataAzurermMonitorActionGroupAutomationRunbookReceiver extends cdktf.ComplexComputedList {
    get automationAccountId(): string;
    get isGlobalRunbook(): cdktf.IResolvable;
    get name(): string;
    get runbookName(): string;
    get serviceUri(): string;
    get useCommonAlertSchema(): cdktf.IResolvable;
    get webhookResourceId(): string;
}
export declare class DataAzurermMonitorActionGroupAzureAppPushReceiver extends cdktf.ComplexComputedList {
    get emailAddress(): string;
    get name(): string;
}
export declare class DataAzurermMonitorActionGroupAzureFunctionReceiver extends cdktf.ComplexComputedList {
    get functionAppResourceId(): string;
    get functionName(): string;
    get httpTriggerUrl(): string;
    get name(): string;
    get useCommonAlertSchema(): cdktf.IResolvable;
}
export declare class DataAzurermMonitorActionGroupEmailReceiver extends cdktf.ComplexComputedList {
    get emailAddress(): string;
    get name(): string;
    get useCommonAlertSchema(): cdktf.IResolvable;
}
export declare class DataAzurermMonitorActionGroupItsmReceiver extends cdktf.ComplexComputedList {
    get connectionId(): string;
    get name(): string;
    get region(): string;
    get ticketConfiguration(): string;
    get workspaceId(): string;
}
export declare class DataAzurermMonitorActionGroupLogicAppReceiver extends cdktf.ComplexComputedList {
    get callbackUrl(): string;
    get name(): string;
    get resourceId(): string;
    get useCommonAlertSchema(): cdktf.IResolvable;
}
export declare class DataAzurermMonitorActionGroupSmsReceiver extends cdktf.ComplexComputedList {
    get countryCode(): string;
    get name(): string;
    get phoneNumber(): string;
}
export declare class DataAzurermMonitorActionGroupVoiceReceiver extends cdktf.ComplexComputedList {
    get countryCode(): string;
    get name(): string;
    get phoneNumber(): string;
}
export declare class DataAzurermMonitorActionGroupWebhookReceiverAadAuth extends cdktf.ComplexComputedList {
    get identifierUri(): string;
    get objectId(): string;
    get tenantId(): string;
}
export declare class DataAzurermMonitorActionGroupWebhookReceiver extends cdktf.ComplexComputedList {
    get aadAuth(): cdktf.IResolvable;
    get name(): string;
    get serviceUri(): string;
    get useCommonAlertSchema(): cdktf.IResolvable;
}
export interface DataAzurermMonitorActionGroupEventHubReceiver {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_action_group#event_hub_id DataAzurermMonitorActionGroup#event_hub_id}
    */
    readonly eventHubId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_action_group#name DataAzurermMonitorActionGroup#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_action_group#tenant_id DataAzurermMonitorActionGroup#tenant_id}
    */
    readonly tenantId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_action_group#use_common_alert_schema DataAzurermMonitorActionGroup#use_common_alert_schema}
    */
    readonly useCommonAlertSchema?: boolean | cdktf.IResolvable;
}
export declare function dataAzurermMonitorActionGroupEventHubReceiverToTerraform(struct?: DataAzurermMonitorActionGroupEventHubReceiver | cdktf.IResolvable): any;
export interface DataAzurermMonitorActionGroupTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_action_group#read DataAzurermMonitorActionGroup#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMonitorActionGroupTimeoutsToTerraform(struct?: DataAzurermMonitorActionGroupTimeoutsOutputReference | DataAzurermMonitorActionGroupTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMonitorActionGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermMonitorActionGroupTimeouts | undefined;
    set internalValue(value: DataAzurermMonitorActionGroupTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_action_group azurerm_monitor_action_group}
*/
export declare class DataAzurermMonitorActionGroup extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_action_group azurerm_monitor_action_group} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMonitorActionGroupConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMonitorActionGroupConfig);
    armRoleReceiver(index: string): DataAzurermMonitorActionGroupArmRoleReceiver;
    automationRunbookReceiver(index: string): DataAzurermMonitorActionGroupAutomationRunbookReceiver;
    azureAppPushReceiver(index: string): DataAzurermMonitorActionGroupAzureAppPushReceiver;
    azureFunctionReceiver(index: string): DataAzurermMonitorActionGroupAzureFunctionReceiver;
    emailReceiver(index: string): DataAzurermMonitorActionGroupEmailReceiver;
    get enabled(): cdktf.IResolvable;
    get id(): string;
    itsmReceiver(index: string): DataAzurermMonitorActionGroupItsmReceiver;
    logicAppReceiver(index: string): DataAzurermMonitorActionGroupLogicAppReceiver;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get shortName(): string;
    smsReceiver(index: string): DataAzurermMonitorActionGroupSmsReceiver;
    voiceReceiver(index: string): DataAzurermMonitorActionGroupVoiceReceiver;
    webhookReceiver(index: string): DataAzurermMonitorActionGroupWebhookReceiver;
    private _eventHubReceiver?;
    get eventHubReceiver(): DataAzurermMonitorActionGroupEventHubReceiver[] | cdktf.IResolvable;
    set eventHubReceiver(value: DataAzurermMonitorActionGroupEventHubReceiver[] | cdktf.IResolvable);
    resetEventHubReceiver(): void;
    get eventHubReceiverInput(): cdktf.IResolvable | DataAzurermMonitorActionGroupEventHubReceiver[] | undefined;
    private _timeouts;
    get timeouts(): DataAzurermMonitorActionGroupTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMonitorActionGroupTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermMonitorActionGroupTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
