import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMonitorScheduledQueryRulesAlertConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_alert#name DataAzurermMonitorScheduledQueryRulesAlert#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_alert#resource_group_name DataAzurermMonitorScheduledQueryRulesAlert#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_alert#timeouts DataAzurermMonitorScheduledQueryRulesAlert#timeouts}
    */
    readonly timeouts?: DataAzurermMonitorScheduledQueryRulesAlertTimeouts;
}
export declare class DataAzurermMonitorScheduledQueryRulesAlertAction extends cdktf.ComplexComputedList {
    get actionGroup(): string[];
    get customWebhookPayload(): string;
    get emailSubject(): string;
}
export declare class DataAzurermMonitorScheduledQueryRulesAlertTriggerMetricTrigger extends cdktf.ComplexComputedList {
    get metricColumn(): string;
    get metricTriggerType(): string;
    get operator(): string;
    get threshold(): number;
}
export declare class DataAzurermMonitorScheduledQueryRulesAlertTrigger extends cdktf.ComplexComputedList {
    get metricTrigger(): cdktf.IResolvable;
    get operator(): string;
    get threshold(): number;
}
export interface DataAzurermMonitorScheduledQueryRulesAlertTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_alert#read DataAzurermMonitorScheduledQueryRulesAlert#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMonitorScheduledQueryRulesAlertTimeoutsToTerraform(struct?: DataAzurermMonitorScheduledQueryRulesAlertTimeoutsOutputReference | DataAzurermMonitorScheduledQueryRulesAlertTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMonitorScheduledQueryRulesAlertTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermMonitorScheduledQueryRulesAlertTimeouts | undefined;
    set internalValue(value: DataAzurermMonitorScheduledQueryRulesAlertTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_alert azurerm_monitor_scheduled_query_rules_alert}
*/
export declare class DataAzurermMonitorScheduledQueryRulesAlert extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/monitor_scheduled_query_rules_alert azurerm_monitor_scheduled_query_rules_alert} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMonitorScheduledQueryRulesAlertConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMonitorScheduledQueryRulesAlertConfig);
    action(index: string): DataAzurermMonitorScheduledQueryRulesAlertAction;
    get authorizedResourceIds(): string[];
    get dataSourceId(): string;
    get description(): string;
    get enabled(): cdktf.IResolvable;
    get frequency(): number;
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get query(): string;
    get queryType(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get severity(): number;
    tags(key: string): string | cdktf.IResolvable;
    get throttling(): number;
    get timeWindow(): number;
    trigger(index: string): DataAzurermMonitorScheduledQueryRulesAlertTrigger;
    private _timeouts;
    get timeouts(): DataAzurermMonitorScheduledQueryRulesAlertTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMonitorScheduledQueryRulesAlertTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermMonitorScheduledQueryRulesAlertTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
