import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMssqlServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_server#name DataAzurermMssqlServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_server#resource_group_name DataAzurermMssqlServer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_server#timeouts DataAzurermMssqlServer#timeouts}
    */
    readonly timeouts?: DataAzurermMssqlServerTimeouts;
}
export declare class DataAzurermMssqlServerIdentity extends cdktf.ComplexComputedList {
    get principalId(): string;
    get tenantId(): string;
    get type(): string;
    get userAssignedIdentityIds(): string[];
}
export interface DataAzurermMssqlServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_server#read DataAzurermMssqlServer#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMssqlServerTimeoutsToTerraform(struct?: DataAzurermMssqlServerTimeoutsOutputReference | DataAzurermMssqlServerTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMssqlServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermMssqlServerTimeouts | undefined;
    set internalValue(value: DataAzurermMssqlServerTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_server azurerm_mssql_server}
*/
export declare class DataAzurermMssqlServer extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/mssql_server azurerm_mssql_server} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMssqlServerConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMssqlServerConfig);
    get administratorLogin(): string;
    get fullyQualifiedDomainName(): string;
    get id(): string;
    identity(index: string): DataAzurermMssqlServerIdentity;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get restorableDroppedDatabaseIds(): string[];
    tags(key: string): string | cdktf.IResolvable;
    get version(): string;
    private _timeouts;
    get timeouts(): DataAzurermMssqlServerTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMssqlServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermMssqlServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
