import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermMysqlFlexibleServerConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_flexible_server#name DataAzurermMysqlFlexibleServer#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_flexible_server#resource_group_name DataAzurermMysqlFlexibleServer#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_flexible_server#timeouts DataAzurermMysqlFlexibleServer#timeouts}
    */
    readonly timeouts?: DataAzurermMysqlFlexibleServerTimeouts;
}
export declare class DataAzurermMysqlFlexibleServerHighAvailability extends cdktf.ComplexComputedList {
    get mode(): string;
    get standbyAvailabilityZone(): string;
}
export declare class DataAzurermMysqlFlexibleServerMaintenanceWindow extends cdktf.ComplexComputedList {
    get dayOfWeek(): number;
    get startHour(): number;
    get startMinute(): number;
}
export declare class DataAzurermMysqlFlexibleServerStorage extends cdktf.ComplexComputedList {
    get autoGrowEnabled(): cdktf.IResolvable;
    get iops(): number;
    get sizeGb(): number;
}
export interface DataAzurermMysqlFlexibleServerTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_flexible_server#read DataAzurermMysqlFlexibleServer#read}
    */
    readonly read?: string;
}
export declare function dataAzurermMysqlFlexibleServerTimeoutsToTerraform(struct?: DataAzurermMysqlFlexibleServerTimeoutsOutputReference | DataAzurermMysqlFlexibleServerTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermMysqlFlexibleServerTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermMysqlFlexibleServerTimeouts | undefined;
    set internalValue(value: DataAzurermMysqlFlexibleServerTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_flexible_server azurerm_mysql_flexible_server}
*/
export declare class DataAzurermMysqlFlexibleServer extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/mysql_flexible_server azurerm_mysql_flexible_server} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermMysqlFlexibleServerConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermMysqlFlexibleServerConfig);
    get administratorLogin(): string;
    get backupRetentionDays(): number;
    get delegatedSubnetId(): string;
    get fqdn(): string;
    get geoRedundantBackupEnabled(): cdktf.IResolvable;
    highAvailability(index: string): DataAzurermMysqlFlexibleServerHighAvailability;
    get id(): string;
    get location(): string;
    maintenanceWindow(index: string): DataAzurermMysqlFlexibleServerMaintenanceWindow;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get privateDnsZoneId(): string;
    get publicNetworkAccessEnabled(): cdktf.IResolvable;
    get replicaCapacity(): number;
    get replicationRole(): string;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get restorePointInTime(): string;
    get skuName(): string;
    storage(index: string): DataAzurermMysqlFlexibleServerStorage;
    tags(key: string): string | cdktf.IResolvable;
    get version(): string;
    get zone(): string;
    private _timeouts;
    get timeouts(): DataAzurermMysqlFlexibleServerTimeoutsOutputReference;
    putTimeouts(value: DataAzurermMysqlFlexibleServerTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermMysqlFlexibleServerTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
