import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNetappAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_account#name DataAzurermNetappAccount#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_account#resource_group_name DataAzurermNetappAccount#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_account#timeouts DataAzurermNetappAccount#timeouts}
    */
    readonly timeouts?: DataAzurermNetappAccountTimeouts;
}
export interface DataAzurermNetappAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_account#read DataAzurermNetappAccount#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNetappAccountTimeoutsToTerraform(struct?: DataAzurermNetappAccountTimeoutsOutputReference | DataAzurermNetappAccountTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNetappAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermNetappAccountTimeouts | undefined;
    set internalValue(value: DataAzurermNetappAccountTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_account azurerm_netapp_account}
*/
export declare class DataAzurermNetappAccount extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/netapp_account azurerm_netapp_account} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNetappAccountConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNetappAccountConfig);
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    get timeouts(): DataAzurermNetappAccountTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNetappAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermNetappAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
