import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermNetworkWatcherConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_watcher#name DataAzurermNetworkWatcher#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_watcher#resource_group_name DataAzurermNetworkWatcher#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_watcher#timeouts DataAzurermNetworkWatcher#timeouts}
    */
    readonly timeouts?: DataAzurermNetworkWatcherTimeouts;
}
export interface DataAzurermNetworkWatcherTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/network_watcher#read DataAzurermNetworkWatcher#read}
    */
    readonly read?: string;
}
export declare function dataAzurermNetworkWatcherTimeoutsToTerraform(struct?: DataAzurermNetworkWatcherTimeoutsOutputReference | DataAzurermNetworkWatcherTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermNetworkWatcherTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermNetworkWatcherTimeouts | undefined;
    set internalValue(value: DataAzurermNetworkWatcherTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/network_watcher azurerm_network_watcher}
*/
export declare class DataAzurermNetworkWatcher extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/network_watcher azurerm_network_watcher} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermNetworkWatcherConfig
    */
    constructor(scope: Construct, id: string, config: DataAzurermNetworkWatcherConfig);
    get id(): string;
    get location(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    tags(key: string): string | cdktf.IResolvable;
    private _timeouts;
    get timeouts(): DataAzurermNetworkWatcherTimeoutsOutputReference;
    putTimeouts(value: DataAzurermNetworkWatcherTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermNetworkWatcherTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
