import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPolicyDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_definition#display_name DataAzurermPolicyDefinition#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_definition#management_group_id DataAzurermPolicyDefinition#management_group_id}
    */
    readonly managementGroupId?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_definition#management_group_name DataAzurermPolicyDefinition#management_group_name}
    */
    readonly managementGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_definition#name DataAzurermPolicyDefinition#name}
    */
    readonly name?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_definition#timeouts DataAzurermPolicyDefinition#timeouts}
    */
    readonly timeouts?: DataAzurermPolicyDefinitionTimeouts;
}
export interface DataAzurermPolicyDefinitionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_definition#read DataAzurermPolicyDefinition#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPolicyDefinitionTimeoutsToTerraform(struct?: DataAzurermPolicyDefinitionTimeoutsOutputReference | DataAzurermPolicyDefinitionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPolicyDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermPolicyDefinitionTimeouts | undefined;
    set internalValue(value: DataAzurermPolicyDefinitionTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/policy_definition azurerm_policy_definition}
*/
export declare class DataAzurermPolicyDefinition extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/policy_definition azurerm_policy_definition} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPolicyDefinitionConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzurermPolicyDefinitionConfig);
    get description(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    private _managementGroupId?;
    get managementGroupId(): string;
    set managementGroupId(value: string);
    resetManagementGroupId(): void;
    get managementGroupIdInput(): string | undefined;
    private _managementGroupName?;
    get managementGroupName(): string;
    set managementGroupName(value: string);
    resetManagementGroupName(): void;
    get managementGroupNameInput(): string | undefined;
    get metadata(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get parameters(): string;
    get policyRule(): string;
    get policyType(): string;
    get type(): string;
    private _timeouts;
    get timeouts(): DataAzurermPolicyDefinitionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPolicyDefinitionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermPolicyDefinitionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
