import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataAzurermPolicySetDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_set_definition#display_name DataAzurermPolicySetDefinition#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_set_definition#management_group_name DataAzurermPolicySetDefinition#management_group_name}
    */
    readonly managementGroupName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_set_definition#name DataAzurermPolicySetDefinition#name}
    */
    readonly name?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_set_definition#timeouts DataAzurermPolicySetDefinition#timeouts}
    */
    readonly timeouts?: DataAzurermPolicySetDefinitionTimeouts;
}
export declare class DataAzurermPolicySetDefinitionPolicyDefinitionGroup extends cdktf.ComplexComputedList {
    get additionalMetadataResourceId(): string;
    get category(): string;
    get description(): string;
    get displayName(): string;
    get name(): string;
}
export declare class DataAzurermPolicySetDefinitionPolicyDefinitionReference extends cdktf.ComplexComputedList {
    get parameterValues(): string;
    get parameters(): {
        [key: string]: string;
    };
    get policyDefinitionId(): string;
    get policyGroupNames(): string[];
    get referenceId(): string;
}
export interface DataAzurermPolicySetDefinitionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/policy_set_definition#read DataAzurermPolicySetDefinition#read}
    */
    readonly read?: string;
}
export declare function dataAzurermPolicySetDefinitionTimeoutsToTerraform(struct?: DataAzurermPolicySetDefinitionTimeoutsOutputReference | DataAzurermPolicySetDefinitionTimeouts | cdktf.IResolvable): any;
export declare class DataAzurermPolicySetDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): DataAzurermPolicySetDefinitionTimeouts | undefined;
    set internalValue(value: DataAzurermPolicySetDefinitionTimeouts | undefined);
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/policy_set_definition azurerm_policy_set_definition}
*/
export declare class DataAzurermPolicySetDefinition extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/policy_set_definition azurerm_policy_set_definition} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataAzurermPolicySetDefinitionConfig = {}
    */
    constructor(scope: Construct, id: string, config?: DataAzurermPolicySetDefinitionConfig);
    get description(): string;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    get id(): string;
    private _managementGroupName?;
    get managementGroupName(): string;
    set managementGroupName(value: string);
    resetManagementGroupName(): void;
    get managementGroupNameInput(): string | undefined;
    get metadata(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    get parameters(): string;
    policyDefinitionGroup(index: string): DataAzurermPolicySetDefinitionPolicyDefinitionGroup;
    policyDefinitionReference(index: string): DataAzurermPolicySetDefinitionPolicyDefinitionReference;
    get policyDefinitions(): string;
    get policyType(): string;
    private _timeouts;
    get timeouts(): DataAzurermPolicySetDefinitionTimeoutsOutputReference;
    putTimeouts(value: DataAzurermPolicySetDefinitionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): DataAzurermPolicySetDefinitionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
